/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OperationArgument {
    private final TypedElement typedElement;
    private final AnnotatedType baseType;
    private final String name;
    private final String description;
    private final Object defaultValue;
    private final boolean context;
    private final boolean mappable;

    public OperationArgument(AnnotatedType javaType, String name, String description, Object defaultValue, Parameter parameter, boolean context, boolean mappable) {
        this(javaType, name, description, defaultValue, Utils.singletonList(parameter), context, mappable);
    }

    public OperationArgument(AnnotatedType javaType, String name, String description, Object defaultValue, List<Parameter> parameters, boolean context, boolean mappable) {
        this.typedElement = new TypedElement(Objects.requireNonNull(javaType), parameters);
        this.baseType = OperationArgument.resolveBaseType(this.typedElement.getJavaType());
        this.name = Objects.requireNonNull(name);
        this.description = description;
        this.defaultValue = defaultValue;
        this.context = context;
        this.mappable = mappable;
    }

    public AnnotatedType getJavaType() {
        return this.typedElement.getJavaType();
    }

    public AnnotatedType getBaseType() {
        return this.baseType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Parameter getParameter() {
        return (Parameter)this.typedElement.getElement();
    }

    public boolean isContext() {
        return this.context;
    }

    public TypedElement getTypedElement() {
        return this.typedElement;
    }

    public boolean isMappable() {
        return this.mappable;
    }

    private static AnnotatedType resolveBaseType(AnnotatedType type) {
        AnnotatedType unwrappedCollectionType = GenericTypeReflector.isSuperType(Collection.class, (Type)type.getType()) ? GenericTypeReflector.getTypeParameter((AnnotatedType)type, Collection.class.getTypeParameters()[0]) : type;
        return GenericTypeReflector.annotate((Type)unwrappedCollectionType.getType());
    }

    public String toString() {
        return String.format("Operation argument '%s' of type %s bound to [%s]", this.name, ClassUtils.toString(this.getJavaType()), this.typedElement.getElements().stream().map(ClassUtils::toString).collect(Collectors.joining()));
    }
}

