/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilderParams;
import io.leangen.graphql.metadata.strategy.value.InputFieldInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.InputParsingException;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class GsonValueMapper
implements ValueMapper,
InputFieldBuilder {
    private final Gson gson;
    private final InputFieldInfoGenerator inputInfoGen = new InputFieldInfoGenerator();

    public GsonValueMapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T fromInput(Object graphQLInput, Type sourceType, AnnotatedType outputType) throws InputParsingException {
        if (graphQLInput.getClass() == outputType.getType()) {
            return (T)graphQLInput;
        }
        try {
            JsonElement jsonElement = this.gson.toJsonTree(graphQLInput, sourceType);
            return (T)this.gson.fromJson(jsonElement, outputType.getType());
        }
        catch (JsonSyntaxException e) {
            throw new InputParsingException(graphQLInput, outputType.getType(), e);
        }
    }

    @Override
    public <T> T fromString(String json, AnnotatedType type) {
        if (json == null || String.class.equals((Object)type.getType())) {
            return (T)json;
        }
        try {
            return (T)this.gson.fromJson(json, type.getType());
        }
        catch (JsonSyntaxException e) {
            throw new InputParsingException(json, type.getType(), e);
        }
    }

    @Override
    public String toString(Object output) {
        if (output == null || output instanceof String) {
            return (String)output;
        }
        return this.gson.toJson(output);
    }

    @Override
    public Set<InputField> getInputFields(InputFieldBuilderParams params) {
        HashSet<InputField> inputFields = new HashSet<InputField>();
        AnnotatedType type = params.getType();
        Class raw = ClassUtils.getRawType(type.getType());
        if (raw.isInterface() || raw.isPrimitive()) {
            return inputFields;
        }
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                Field target;
                AnnotatedType fieldType;
                if (this.gson.excluder().excludeClass(field.getType(), false) || this.gson.excluder().excludeField(field, false)) continue;
                try {
                    fieldType = params.getEnvironment().typeTransformer.transform(ClassUtils.getFieldType(field, type));
                }
                catch (TypeMappingException e) {
                    throw new TypeMappingException(field, type, (Exception)e);
                }
                Optional<Method> setter = ClassUtils.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
                Member member = target = setter.isPresent() ? (Member)setter.get() : field;
                if (!params.getEnvironment().inclusionStrategy.includeInputField(target.getDeclaringClass(), target, fieldType)) continue;
                field.setAccessible(true);
                String fieldName = this.gson.fieldNamingStrategy().translateName(field);
                InputField inputField = new InputField(fieldName, this.getDescription(field, params.getEnvironment().messageBundle), fieldType, null, this.defaultValue(field, fieldType, params.getEnvironment()), target);
                if (inputFields.add(inputField)) continue;
                throw new IllegalArgumentException(raw + " declares multiple input fields named " + fieldName);
            }
            raw = raw.getSuperclass();
            type = GenericTypeReflector.getExactSuperType((AnnotatedType)type, raw);
        }
        return inputFields;
    }

    protected String getDescription(Field field, MessageBundle messageBundle) {
        return this.inputInfoGen.getDescription(ClassUtils.getPropertyMembers(field), messageBundle).orElse(null);
    }

    protected Object defaultValue(Field field, AnnotatedType fieldType, GlobalEnvironment environment) {
        return this.inputInfoGen.defaultValue(ClassUtils.getPropertyMembers(field), fieldType, environment).orElse(null);
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return true;
    }
}

