/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.module.common.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLScalarType;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GsonScalars {
    public static final GraphQLScalarType JsonAnyNode = new GraphQLScalarType("JSON", "JSON object", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof JsonPrimitive) {
                return JsonPrimitiveNode.getCoercing().serialize(dataFetcherResult);
            }
            return dataFetcherResult;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) {
            return GsonScalars.parseJsonValue((Value)input);
        }
    });
    public static final GraphQLScalarType JsonObjectNode = new GraphQLScalarType("JSONObject", "JSON object", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            return dataFetcherResult;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) {
            return GsonScalars.parseJsonValue((Value)Scalars.literalOrException(input, ObjectValue.class));
        }
    });
    public static final GraphQLScalarType JsonPrimitiveNode = new GraphQLScalarType("JSONPrimitive", "A primitive JSON value", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)dataFetcherResult;
                if (primitive.isString()) {
                    return primitive.getAsString();
                }
                if (primitive.isNumber()) {
                    return primitive.getAsNumber();
                }
                if (primitive.isBoolean()) {
                    return primitive.getAsBoolean();
                }
                if (primitive.isJsonNull()) {
                    return null;
                }
            }
            throw Scalars.serializationException(dataFetcherResult, JsonPrimitive.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return new JsonPrimitive((String)input);
            }
            if (input instanceof Number) {
                return new JsonPrimitive((Number)input);
            }
            if (input instanceof Boolean) {
                return new JsonPrimitive((Boolean)input);
            }
            if (input instanceof Character) {
                return new JsonPrimitive((Character)input);
            }
            throw Scalars.valueParsingException(input, String.class, Number.class, Boolean.class, Character.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof ObjectValue || input instanceof ArrayValue) {
                throw Scalars.literalParsingException(input, StringValue.class, BooleanValue.class, EnumValue.class, FloatValue.class, IntValue.class, NullValue.class);
            }
            return GsonScalars.parseJsonValue((Value)input);
        }
    });
    private static final Map<Type, GraphQLScalarType> SCALAR_MAPPING = GsonScalars.getScalarMapping();

    private static JsonElement parseJsonValue(Value value) {
        if (value instanceof BooleanValue) {
            return new JsonPrimitive(Boolean.valueOf(((BooleanValue)value).isValue()));
        }
        if (value instanceof EnumValue) {
            return new JsonPrimitive(((EnumValue)value).getName());
        }
        if (value instanceof FloatValue) {
            return new JsonPrimitive((Number)((FloatValue)value).getValue());
        }
        if (value instanceof IntValue) {
            return new JsonPrimitive((Number)((IntValue)value).getValue());
        }
        if (value instanceof NullValue) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof StringValue) {
            return new JsonPrimitive(((StringValue)value).getValue());
        }
        if (value instanceof ArrayValue) {
            List values = ((ArrayValue)value).getValues();
            JsonArray jsonArray = new JsonArray(values.size());
            values.forEach(v -> jsonArray.add(GsonScalars.parseJsonValue(v)));
            return jsonArray;
        }
        if (value instanceof ObjectValue) {
            JsonObject result = new JsonObject();
            ((ObjectValue)value).getObjectFields().forEach(objectField -> result.add(objectField.getName(), GsonScalars.parseJsonValue(objectField.getValue())));
            return result;
        }
        throw new CoercingParseLiteralException("Unknown scalar AST type: " + value.getClass().getName());
    }

    public static boolean isScalar(Type javaType) {
        return SCALAR_MAPPING.containsKey(javaType);
    }

    public static GraphQLScalarType toGraphQLScalarType(Type javaType) {
        return SCALAR_MAPPING.get(javaType);
    }

    private static Map<Type, GraphQLScalarType> getScalarMapping() {
        HashMap<Class<JsonPrimitive>, GraphQLScalarType> scalarMapping = new HashMap<Class<JsonPrimitive>, GraphQLScalarType>();
        scalarMapping.put(JsonObject.class, JsonObjectNode);
        scalarMapping.put(JsonElement.class, JsonAnyNode);
        scalarMapping.put(JsonPrimitive.class, JsonPrimitiveNode);
        return Collections.unmodifiableMap(scalarMapping);
    }
}

