/*
 * Decompiled with CFR 0.152.
 */
package io.leego.banana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Ansi {
    public static final Ansi BLACK;
    public static final Ansi RED;
    public static final Ansi GREEN;
    public static final Ansi YELLOW;
    public static final Ansi BLUE;
    public static final Ansi PURPLE;
    public static final Ansi CYAN;
    public static final Ansi WHITE;
    public static final Ansi BG_BLACK;
    public static final Ansi BG_RED;
    public static final Ansi BG_GREEN;
    public static final Ansi BG_YELLOW;
    public static final Ansi BG_BLUE;
    public static final Ansi BG_PURPLE;
    public static final Ansi BG_CYAN;
    public static final Ansi BG_WHITE;
    public static final Ansi NORMAL;
    public static final Ansi BOLD;
    public static final Ansi FAINT;
    public static final Ansi ITALIC;
    public static final Ansi UNDERLINE;
    public static final Ansi SLOW_BLINK;
    public static final Ansi RAPID_BLINK;
    public static final Ansi REVERSE_VIDEO;
    public static final Ansi CONCEAL;
    public static final Ansi CROSSED_OUT;
    public static final Ansi PRIMARY;
    private static final List<Ansi> VALUES;
    private static final Map<String, Ansi> MAP;
    protected final String code;

    protected Ansi(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getAnsi() {
        return "\u001b[" + this.code + "m";
    }

    public static String ansify(String text, Ansi style) {
        if (text == null || text.isEmpty() || style == null) {
            return text;
        }
        return style.getAnsi() + text + NORMAL.getAnsi();
    }

    public static String ansify(String text, Ansi ... styles) {
        if (text == null || text.isEmpty() || styles == null || styles.length == 0) {
            return text;
        }
        int count = 0;
        StringBuilder sb = new StringBuilder("\u001b[");
        for (Ansi style : styles) {
            if (style != null) {
                sb.append(style.getCode()).append(";");
                continue;
            }
            ++count;
        }
        if (count == styles.length) {
            return text;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append("m").append(text).append(NORMAL.getAnsi()).toString();
    }

    public static List<Ansi> values() {
        return VALUES;
    }

    public static Ansi get(String code) {
        return MAP.get(code);
    }

    public static Ansi getOrDefault(String code, Ansi defaultValue) {
        Ansi ansi = MAP.get(code);
        return ansi != null ? ansi : defaultValue;
    }

    static {
        ArrayList<Ansi> values = new ArrayList<Ansi>();
        BLACK = new Ansi("30");
        values.add(BLACK);
        RED = new Ansi("31");
        values.add(RED);
        GREEN = new Ansi("32");
        values.add(GREEN);
        YELLOW = new Ansi("33");
        values.add(YELLOW);
        BLUE = new Ansi("34");
        values.add(BLUE);
        PURPLE = new Ansi("35");
        values.add(PURPLE);
        CYAN = new Ansi("36");
        values.add(CYAN);
        WHITE = new Ansi("37");
        values.add(WHITE);
        BG_BLACK = new Ansi("40");
        values.add(BG_BLACK);
        BG_RED = new Ansi("41");
        values.add(BG_RED);
        BG_GREEN = new Ansi("42");
        values.add(BG_GREEN);
        BG_YELLOW = new Ansi("43");
        values.add(BG_YELLOW);
        BG_BLUE = new Ansi("44");
        values.add(BG_BLUE);
        BG_PURPLE = new Ansi("45");
        values.add(BG_PURPLE);
        BG_CYAN = new Ansi("46");
        values.add(BG_CYAN);
        BG_WHITE = new Ansi("47");
        values.add(BG_WHITE);
        NORMAL = new Ansi("0");
        values.add(NORMAL);
        BOLD = new Ansi("1");
        values.add(BOLD);
        FAINT = new Ansi("2");
        values.add(FAINT);
        ITALIC = new Ansi("3");
        values.add(ITALIC);
        UNDERLINE = new Ansi("4");
        values.add(UNDERLINE);
        SLOW_BLINK = new Ansi("5");
        values.add(SLOW_BLINK);
        RAPID_BLINK = new Ansi("6");
        values.add(RAPID_BLINK);
        REVERSE_VIDEO = new Ansi("7");
        values.add(REVERSE_VIDEO);
        CONCEAL = new Ansi("8");
        values.add(CONCEAL);
        CROSSED_OUT = new Ansi("9");
        values.add(CROSSED_OUT);
        PRIMARY = new Ansi("10");
        values.add(PRIMARY);
        HashMap<String, Ansi> map = new HashMap<String, Ansi>(values.size());
        for (Ansi v : values) {
            map.put(v.code, v);
        }
        VALUES = Collections.unmodifiableList(values);
        MAP = Collections.unmodifiableMap(map);
    }
}

