/*
 * Decompiled with CFR 0.152.
 */
package io.leego.banana;

import io.leego.banana.Ansi;
import io.leego.banana.Font;
import io.leego.banana.Layout;
import io.leego.banana.Meta;
import io.leego.banana.Option;
import io.leego.banana.Rule;
import io.leego.banana.RuleEnum;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class BananaUtils {
    private static final int INVALID = 0;
    private static final int VALID = 1;
    private static final int END = 2;
    private static final String EMPTY = "";
    private static final String WHITESPACE = " ";
    private static final List<Integer> CODES;
    private static final ConcurrentMap<Font, Meta> cache;

    private BananaUtils() {
    }

    public static List<Font> fonts() {
        return Font.values();
    }

    public static String bananaify(String text) {
        return BananaUtils.bananaify(text, null, null, null);
    }

    public static String bananaify(String text, Layout horizontalLayout, Layout verticalLayout) {
        return BananaUtils.bananaify(text, null, horizontalLayout, verticalLayout);
    }

    public static String bananaify(String text, Font font) {
        return BananaUtils.bananaify(text, font, null, null);
    }

    public static String bananaify(String text, Font font, Layout horizontalLayout, Layout verticalLayout) {
        String[] lines = BananaUtils.generateFiglet(text, font, horizontalLayout, verticalLayout);
        if (lines == null || lines.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            sb.append(s).append('\n');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String bananansi(String text, Ansi ... styles) {
        return BananaUtils.bananansi(text, null, null, null, styles);
    }

    public static String bananansi(String text, Layout horizontalLayout, Layout verticalLayout, Ansi ... styles) {
        return BananaUtils.bananansi(text, null, horizontalLayout, verticalLayout, styles);
    }

    public static String bananansi(String text, Font font, Ansi ... styles) {
        return BananaUtils.bananansi(text, font, null, null, styles);
    }

    public static String bananansi(String text, Font font, Layout horizontalLayout, Layout verticalLayout, Ansi ... styles) {
        String[] lines = BananaUtils.generateFiglet(text, font, horizontalLayout, verticalLayout);
        if (lines == null || lines.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            sb.append(Ansi.ansify(s, styles)).append('\n');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String[] generateFiglet(String text, Font font, Layout horizontalLayout, Layout verticalLayout) {
        if (text == null) {
            return new String[0];
        }
        Meta meta = BananaUtils.getMeta(font);
        if (meta == null) {
            return new String[0];
        }
        Option option = BananaUtils.setLayout(meta.getOption(), horizontalLayout, verticalLayout);
        String[] lines = text.split("\\r?\\n");
        String[][] figletLines = new String[lines.length][];
        for (int i = 0; i < lines.length; ++i) {
            figletLines[i] = BananaUtils.generateFigletLine(lines[i], meta.getFigletMap(), option);
        }
        String[] output = figletLines[0];
        for (int i = 1; i < figletLines.length; ++i) {
            output = BananaUtils.smushVerticalFigletLines(output, figletLines[i], option);
        }
        return output;
    }

    private static Meta getMeta(Font font) {
        Meta cachedMeta;
        if (font == null) {
            font = Font.STANDARD;
        }
        if ((cachedMeta = (Meta)cache.get(font)) != null) {
            return cachedMeta;
        }
        Meta newMeta = BananaUtils.buildMeta(font);
        if (newMeta != null) {
            cache.putIfAbsent(font, newMeta);
            return newMeta;
        }
        return null;
    }

    private static Meta buildMeta(Font font) {
        ArrayList<String> data = new ArrayList<String>();
        try (InputStream inputStream = font.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, font.getCharset());
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                data.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load font '" + font.getName() + "'.", e);
        }
        Option option = new Option();
        String[] header = ((String)data.get(0)).split(WHITESPACE);
        option.setHardBlank(header[0].substring(5, 6));
        option.setHeight(Integer.parseInt(header[1]));
        option.setBaseline(Integer.parseInt(header[2]));
        option.setMaxLength(Integer.parseInt(header[3]));
        option.setOldLayout(Integer.parseInt(header[4]));
        option.setNumCommentLines(Integer.parseInt(header[5]));
        option.setPrintDirection(header.length > 6 ? Integer.parseInt(header[6]) : 0);
        option.setFullLayout(header.length > 7 ? Integer.valueOf(Integer.parseInt(header[7])) : null);
        option.setCodeTagCount(header.length > 8 ? Integer.valueOf(Integer.parseInt(header[8])) : null);
        option.setRule(BananaUtils.getSmushRule(option.getOldLayout(), option.getFullLayout()));
        StringBuilder comment = new StringBuilder();
        int num = 0;
        while (++num <= option.getNumCommentLines()) {
            comment.append((String)data.get(num)).append("\n");
        }
        List<Integer> codes = CODES;
        int height = option.getHeight();
        HashMap<Integer, String[]> figletMap = new HashMap<Integer, String[]>(codes.size());
        block31: for (int i = 0; i < codes.size(); ++i) {
            Integer code = codes.get(i);
            if (i * height + num >= data.size()) break;
            String[] figlet = new String[height];
            figletMap.put(code, figlet);
            for (int j = 0; j < height; ++j) {
                int charIndex;
                int row = i * height + j + num;
                if (row >= data.size()) {
                    figletMap.remove(code);
                    continue block31;
                }
                String charRow = (String)data.get(row);
                for (charIndex = charRow.length() - 1; charIndex >= 0 && Character.isWhitespace(charRow.charAt(charIndex)); --charIndex) {
                }
                char endChar = charRow.charAt(charIndex);
                while (charIndex >= 0 && charRow.charAt(charIndex) == endChar) {
                    --charIndex;
                }
                figlet[j] = charRow.substring(0, charIndex + 1);
            }
        }
        data.clear();
        return new Meta(font, option, figletMap, comment.toString());
    }

    private static String[] generateFigletLine(String text, Map<Integer, String[]> figletMap, Option option) {
        int i;
        int height = option.getHeight();
        String[] output = new String[height];
        for (i = 0; i < height; ++i) {
            output[i] = EMPTY;
        }
        for (int index = 0; index < text.length(); ++index) {
            String[] figlet = figletMap.get(text.charAt(index));
            if (figlet == null) continue;
            int overlap = 0;
            if (option.getRule().getHorizontalLayout() != Layout.FULL) {
                int length = Integer.MAX_VALUE;
                for (int i2 = 0; i2 < height; ++i2) {
                    length = Math.min(length, BananaUtils.getHorizontalSmushLength(output[i2], figlet[i2], option));
                }
                overlap = length == Integer.MAX_VALUE ? 0 : length;
            }
            output = BananaUtils.smushHorizontal(output, figlet, overlap, option);
        }
        for (i = 0; i < output.length; ++i) {
            output[i] = output[i].replace(option.getHardBlank(), WHITESPACE);
        }
        return output;
    }

    private static Option setLayout(Option option, Layout horizontalLayout, Layout verticalLayout) {
        if (!(horizontalLayout != null && horizontalLayout != Layout.DEFAULT || verticalLayout != null && verticalLayout != Layout.DEFAULT)) {
            return option;
        }
        Option newOption = option.copy();
        BananaUtils.setHorizontalLayout(newOption, horizontalLayout);
        BananaUtils.setVerticalLayout(newOption, verticalLayout);
        return newOption;
    }

    private static void setHorizontalLayout(Option option, Layout layout) {
        if (layout == null || layout == Layout.DEFAULT) {
            return;
        }
        Rule rule = option.getRule();
        if (layout == Layout.FULL) {
            rule.setHorizontal(Layout.FULL, false, false, false, false, false, false);
        } else if (layout == Layout.FITTED) {
            rule.setHorizontal(Layout.FITTED, false, false, false, false, false, false);
        } else if (layout == Layout.SMUSH_U) {
            rule.setHorizontal(Layout.SMUSH_U, false, false, false, false, false, false);
        } else if (layout == Layout.SMUSH_R) {
            rule.setHorizontal(Layout.SMUSH_R, true, true, true, true, true, true);
        }
    }

    private static void setVerticalLayout(Option option, Layout layout) {
        if (layout == null || layout == Layout.DEFAULT) {
            return;
        }
        Rule rule = option.getRule();
        if (layout == Layout.FULL) {
            rule.setVertical(Layout.FULL, false, false, false, false, false);
        } else if (layout == Layout.FITTED) {
            rule.setVertical(Layout.FITTED, false, false, false, false, false);
        } else if (layout == Layout.SMUSH_U) {
            rule.setVertical(Layout.SMUSH_U, false, false, false, false, false);
        } else if (layout == Layout.SMUSH_R) {
            rule.setVertical(Layout.SMUSH_R, true, true, true, true, true);
        }
    }

    private static String[] smushHorizontal(String[] figlet1, String[] figlet2, int overlap, Option option) {
        int height = option.getHeight();
        Rule rule = option.getRule();
        String hardBlank = option.getHardBlank();
        String[] output = new String[height];
        for (int i = 0; i < height; ++i) {
            String text1 = figlet1[i];
            String text2 = figlet2[i];
            int len1 = text1.length();
            int len2 = text2.length();
            int overlapStart = len1 - overlap;
            StringBuilder piece = new StringBuilder();
            piece.append(BananaUtils.substr(text1, 0, Math.max(0, overlapStart)));
            String seg1 = BananaUtils.substr(text1, Math.max(0, len1 - overlap), overlap);
            String seg2 = BananaUtils.substr(text2, 0, Math.min(overlap, len2));
            for (int j = 0; j < overlap; ++j) {
                String ch2;
                String ch1 = j < len1 ? BananaUtils.substr(seg1, j, 1) : WHITESPACE;
                String string = ch2 = j < len2 ? BananaUtils.substr(seg2, j, 1) : WHITESPACE;
                if (!WHITESPACE.equals(ch1) && !WHITESPACE.equals(ch2)) {
                    if (rule.getHorizontalLayout() == Layout.FITTED) {
                        piece.append(BananaUtils.smushUniversal(ch1, ch2, hardBlank));
                        continue;
                    }
                    if (rule.getHorizontalLayout() == Layout.SMUSH_U) {
                        piece.append(BananaUtils.smushUniversal(ch1, ch2, hardBlank));
                        continue;
                    }
                    String nextCh = EMPTY;
                    if (BananaUtils.isEmpty(nextCh) && rule.isHorizontal1()) {
                        nextCh = BananaUtils.smushHorizontalRule1(ch1, ch2, hardBlank);
                    }
                    if (BananaUtils.isEmpty(nextCh) && rule.isHorizontal2()) {
                        nextCh = BananaUtils.smushHorizontalRule2(ch1, ch2);
                    }
                    if (BananaUtils.isEmpty(nextCh) && rule.isHorizontal3()) {
                        nextCh = BananaUtils.smushHorizontalRule3(ch1, ch2);
                    }
                    if (BananaUtils.isEmpty(nextCh) && rule.isHorizontal4()) {
                        nextCh = BananaUtils.smushHorizontalRule4(ch1, ch2);
                    }
                    if (BananaUtils.isEmpty(nextCh) && rule.isHorizontal5()) {
                        nextCh = BananaUtils.smushHorizontalRule5(ch1, ch2);
                    }
                    if (BananaUtils.isEmpty(nextCh) && rule.isHorizontal6()) {
                        nextCh = BananaUtils.smushHorizontalRule6(ch1, ch2, hardBlank);
                    }
                    if (BananaUtils.isEmpty(nextCh)) {
                        nextCh = BananaUtils.smushUniversal(ch1, ch2, hardBlank);
                    }
                    piece.append(nextCh);
                    continue;
                }
                piece.append(BananaUtils.smushUniversal(ch1, ch2, hardBlank));
            }
            if (overlap < len2) {
                piece.append(BananaUtils.substr(text2, overlap, Math.max(0, len2 - overlap)));
            }
            output[i] = piece.toString();
        }
        return output;
    }

    private static int getHorizontalSmushLength(String text1, String text2, Option option) {
        int curDist;
        Rule rule = option.getRule();
        String hardBlank = option.getHardBlank();
        if (rule.getHorizontalLayout() == Layout.FULL) {
            return 0;
        }
        int len1 = text1.length();
        int len2 = text2.length();
        int maxDist = text1.length();
        boolean breakAfter = false;
        boolean validSmush = false;
        if (len1 == 0) {
            return 0;
        }
        for (curDist = 1; curDist <= maxDist; ++curDist) {
            boolean skip = false;
            String seg1 = BananaUtils.substr(text1, len1 - curDist, len1);
            String seg2 = BananaUtils.substr(text2, 0, Math.min(curDist, len2));
            for (int i = 0; i < Math.min(curDist, len2); ++i) {
                String ch1 = BananaUtils.substr(seg1, i, 1);
                String ch2 = BananaUtils.substr(seg2, i, 1);
                if (WHITESPACE.equals(ch1) || WHITESPACE.equals(ch2)) continue;
                if (rule.getHorizontalLayout() == Layout.FITTED) {
                    --curDist;
                    skip = true;
                    break;
                }
                if (rule.getHorizontalLayout() == Layout.SMUSH_U) {
                    if (BananaUtils.equals(ch1, hardBlank) || BananaUtils.equals(ch2, hardBlank)) {
                        --curDist;
                    }
                    skip = true;
                    break;
                }
                breakAfter = true;
                validSmush = false;
                if (rule.isHorizontal1()) {
                    validSmush = BananaUtils.isNotEmpty(BananaUtils.smushHorizontalRule1(ch1, ch2, hardBlank));
                }
                if (!validSmush && rule.isHorizontal2()) {
                    validSmush = BananaUtils.isNotEmpty(BananaUtils.smushHorizontalRule2(ch1, ch2));
                }
                if (!validSmush && rule.isHorizontal3()) {
                    validSmush = BananaUtils.isNotEmpty(BananaUtils.smushHorizontalRule3(ch1, ch2));
                }
                if (!validSmush && rule.isHorizontal4()) {
                    validSmush = BananaUtils.isNotEmpty(BananaUtils.smushHorizontalRule4(ch1, ch2));
                }
                if (!validSmush && rule.isHorizontal5()) {
                    validSmush = BananaUtils.isNotEmpty(BananaUtils.smushHorizontalRule5(ch1, ch2));
                }
                if (!validSmush && rule.isHorizontal6()) {
                    validSmush = BananaUtils.isNotEmpty(BananaUtils.smushHorizontalRule6(ch1, ch2, hardBlank));
                }
                if (validSmush) continue;
                --curDist;
                skip = true;
                break;
            }
            if (skip || breakAfter) break;
        }
        return Math.min(maxDist, curDist);
    }

    private static Rule getSmushRule(Integer oldLayout, Integer newLayout) {
        HashMap<String, Integer> rules = new HashMap<String, Integer>();
        RuleEnum[] ruleEnums = RuleEnum.values();
        int layout = newLayout != null ? newLayout : oldLayout;
        for (RuleEnum rule : ruleEnums) {
            String key = rule.getKey();
            int code = rule.getCode();
            int value = rule.getValue();
            if (layout >= code) {
                layout -= code;
                if (rules.containsKey(key)) continue;
                rules.put(key, value);
                continue;
            }
            if (BananaUtils.equals(RuleEnum.HORIZONTAL_LAYOUT_SMUSH.getKey(), key) || BananaUtils.equals(RuleEnum.VERTICAL_LAYOUT_SMUSH.getKey(), key)) continue;
            rules.put(key, 0);
        }
        Rule rule = new Rule(Layout.get((Integer)rules.get(RuleEnum.HORIZONTAL_LAYOUT_SMUSH.getKey())), BananaUtils.equals(rules.get(RuleEnum.HORIZONTAL_1.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.HORIZONTAL_2.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.HORIZONTAL_3.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.HORIZONTAL_4.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.HORIZONTAL_5.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.HORIZONTAL_6.getKey()), 1), Layout.get((Integer)rules.get(RuleEnum.VERTICAL_LAYOUT_SMUSH.getKey())), BananaUtils.equals(rules.get(RuleEnum.VERTICAL_1.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.VERTICAL_2.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.VERTICAL_3.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.VERTICAL_4.getKey()), 1), BananaUtils.equals(rules.get(RuleEnum.VERTICAL_5.getKey()), 1));
        if (rule.getHorizontalLayout() == null) {
            if (oldLayout == 0) {
                rule.setHorizontalLayout(Layout.FITTED);
            } else if (oldLayout == -1) {
                rule.setHorizontalLayout(Layout.FULL);
            } else if (rule.isHorizontal1() || rule.isHorizontal2() || rule.isHorizontal3() || rule.isHorizontal4() || rule.isHorizontal5() || rule.isHorizontal6()) {
                rule.setHorizontalLayout(Layout.SMUSH_R);
            } else {
                rule.setHorizontalLayout(Layout.SMUSH_U);
            }
        } else if (rule.getHorizontalLayout() == Layout.SMUSH_U && rule.isHorizontal1() || rule.isHorizontal2() || rule.isHorizontal3() || rule.isHorizontal4() || rule.isHorizontal5() || rule.isHorizontal6()) {
            rule.setHorizontalLayout(Layout.SMUSH_R);
        }
        if (rule.getVerticalLayout() == null) {
            if (rule.isVertical1() || rule.isVertical2() || rule.isVertical3() || rule.isVertical4() || rule.isVertical5()) {
                rule.setVerticalLayout(Layout.SMUSH_R);
            } else {
                rule.setVerticalLayout(Layout.FULL);
            }
        } else if (rule.getVerticalLayout() == Layout.SMUSH_U && rule.isVertical1() || rule.isVertical2() || rule.isVertical3() || rule.isVertical4() || rule.isVertical5()) {
            rule.setVerticalLayout(Layout.SMUSH_R);
        }
        return rule;
    }

    private static String[] smushVerticalFigletLines(String[] figlet1, String[] figlet2, Option option) {
        int len2;
        int len1 = figlet1[0].length();
        if (len1 > (len2 = figlet2[0].length())) {
            BananaUtils.padLines(figlet2, len1 - len2);
        } else if (len2 > len1) {
            BananaUtils.padLines(figlet1, len2 - len1);
        }
        int overlap = BananaUtils.getVerticalSmushDist(figlet1, figlet2, option);
        return BananaUtils.smushVertical(figlet1, figlet2, overlap, option);
    }

    private static void padLines(String[] lines, int numSpaces) {
        StringBuilder padding = new StringBuilder();
        for (int i = 0; i < numSpaces; ++i) {
            padding.append(WHITESPACE);
        }
        String padded = padding.toString();
        int i = 0;
        while (i < lines.length) {
            int n = i++;
            lines[n] = lines[n] + padded;
        }
    }

    private static int getVerticalSmushDist(String[] figlet1, String[] figlet2, Option option) {
        int curDist;
        int maxDist = figlet1.length;
        int len1 = figlet1.length;
        for (curDist = 1; curDist <= maxDist; ++curDist) {
            String[] subLines1 = BananaUtils.slice(figlet1, Math.max(0, len1 - curDist), len1);
            String[] subLines2 = BananaUtils.slice(figlet2, 0, Math.min(maxDist, curDist));
            int result = 1;
            for (int i = 0; i < subLines2.length; ++i) {
                int ret = BananaUtils.canSmushVertical(subLines1[i], subLines2[i], option);
                if (2 == ret) {
                    result = ret;
                    continue;
                }
                if (0 != ret) continue;
                result = ret;
                break;
            }
            if (0 == result) {
                --curDist;
                break;
            }
            if (2 == result) break;
        }
        return Math.min(maxDist, curDist);
    }

    private static int canSmushVertical(String line1, String line2, Option option) {
        Rule rule = option.getRule();
        if (rule.getVerticalLayout() == Layout.FULL) {
            return 0;
        }
        int len = Math.min(line1.length(), line2.length());
        boolean endSmush = false;
        if (len == 0) {
            return 0;
        }
        for (int i = 0; i < len; ++i) {
            String ch1 = BananaUtils.substr(line1, i, 1);
            String ch2 = BananaUtils.substr(line2, i, 1);
            if (WHITESPACE.equals(ch1) || WHITESPACE.equals(ch2)) continue;
            if (rule.getVerticalLayout() == Layout.FITTED) {
                return 0;
            }
            if (rule.getVerticalLayout() == Layout.SMUSH_U) {
                return 2;
            }
            if (BananaUtils.isNotEmpty(BananaUtils.smushVerticalRule5(ch1, ch2))) continue;
            boolean validSmush = false;
            if (rule.isVertical1()) {
                validSmush = BananaUtils.isNotEmpty(BananaUtils.smushVerticalRule1(ch1, ch2));
            }
            if (!validSmush && rule.isVertical2()) {
                validSmush = BananaUtils.isNotEmpty(BananaUtils.smushVerticalRule2(ch1, ch2));
            }
            if (!validSmush && rule.isVertical3()) {
                validSmush = BananaUtils.isNotEmpty(BananaUtils.smushVerticalRule3(ch1, ch2));
            }
            if (!validSmush && rule.isVertical4()) {
                validSmush = BananaUtils.isNotEmpty(BananaUtils.smushVerticalRule4(ch1, ch2));
            }
            endSmush = true;
            if (validSmush) continue;
            return 0;
        }
        if (endSmush) {
            return 2;
        }
        return 1;
    }

    private static String[] smushVertical(String[] figlet1, String[] figlet2, int overlap, Option option) {
        int len1 = figlet1.length;
        int len2 = figlet2.length;
        String[] piece1 = BananaUtils.slice(figlet1, 0, Math.max(0, len1 - overlap));
        String[] piece21 = BananaUtils.slice(figlet1, Math.max(0, len1 - overlap), len1);
        String[] piece22 = BananaUtils.slice(figlet2, 0, Math.min(overlap, len2));
        String[] piece2 = new String[piece21.length];
        for (int i = 0; i < piece21.length; ++i) {
            String line = i >= len2 ? piece21[i] : BananaUtils.smushVerticalLines(piece21[i], piece22[i], option);
            piece2[i] = line;
        }
        String[] piece3 = BananaUtils.slice(figlet2, Math.min(overlap, len2), len2);
        return BananaUtils.concat(piece1, piece2, piece3);
    }

    private static String smushVerticalLines(String line1, String line2, Option option) {
        Rule rule = option.getRule();
        int len = Math.min(line1.length(), line2.length());
        String validSmush = EMPTY;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            String ch1 = BananaUtils.substr(line1, i, 1);
            String ch2 = BananaUtils.substr(line2, i, 1);
            if (!WHITESPACE.equals(ch1) && !WHITESPACE.equals(ch2)) {
                if (rule.getVerticalLayout() == Layout.FITTED) {
                    result.append(BananaUtils.smushUniversal(ch1, ch2, null));
                    continue;
                }
                if (rule.getVerticalLayout() == Layout.SMUSH_U) {
                    result.append(BananaUtils.smushUniversal(ch1, ch2, null));
                    continue;
                }
                if (rule.isVertical5()) {
                    validSmush = BananaUtils.smushVerticalRule5(ch1, ch2);
                }
                if (BananaUtils.isEmpty(validSmush) && rule.isVertical1()) {
                    validSmush = BananaUtils.smushVerticalRule1(ch1, ch2);
                }
                if (BananaUtils.isEmpty(validSmush) && rule.isVertical2()) {
                    validSmush = BananaUtils.smushVerticalRule2(ch1, ch2);
                }
                if (BananaUtils.isEmpty(validSmush) && rule.isVertical3()) {
                    validSmush = BananaUtils.smushVerticalRule3(ch1, ch2);
                }
                if (BananaUtils.isEmpty(validSmush) && rule.isVertical4()) {
                    validSmush = BananaUtils.smushVerticalRule4(ch1, ch2);
                }
                result.append(validSmush);
                continue;
            }
            result.append(BananaUtils.smushUniversal(ch1, ch2, null));
        }
        return result.toString();
    }

    private static String smushHorizontalRule1(String s1, String s2, String hardBlank) {
        if (BananaUtils.equals(s1, s2) && !BananaUtils.equals(s1, hardBlank)) {
            return s1;
        }
        return EMPTY;
    }

    private static String smushHorizontalRule2(String s1, String s2) {
        String rule = "|/\\[]{}()<>";
        if (BananaUtils.equals("_", s1)) {
            if (rule.contains(s2)) {
                return s2;
            }
        } else if (BananaUtils.equals("_", s2) && rule.contains(s1)) {
            return s1;
        }
        return EMPTY;
    }

    private static String smushHorizontalRule3(String s1, String s2) {
        String rule = "| /\\ [] {} () <>";
        int pos1 = rule.indexOf(s1);
        int pos2 = rule.indexOf(s2);
        if (pos1 != -1 && pos2 != -1 && pos1 != pos2 && Math.abs(pos1 - pos2) != 1) {
            return BananaUtils.substr(rule, Math.max(pos1, pos2), 1);
        }
        return EMPTY;
    }

    private static String smushHorizontalRule4(String s1, String s2) {
        String rule = "[] {} ()";
        int pos1 = rule.indexOf(s1);
        int pos2 = rule.indexOf(s2);
        if (pos1 != -1 && pos2 != -1 && Math.abs(pos1 - pos2) <= 1) {
            return "|";
        }
        return EMPTY;
    }

    private static String smushHorizontalRule5(String s1, String s2) {
        String rule = "/\\ \\/ ><";
        int pos1 = rule.indexOf(s1);
        int pos2 = rule.indexOf(s2);
        if (pos1 != -1 && pos2 != -1 && pos2 - pos1 == 1) {
            if (pos1 == 0) {
                return "|";
            }
            if (pos1 == 3) {
                return "Y";
            }
            if (pos1 == 6) {
                return "X";
            }
        }
        return EMPTY;
    }

    private static String smushHorizontalRule6(String s1, String s2, String hardBlank) {
        if (BananaUtils.equals(s1, hardBlank) && BananaUtils.equals(s2, hardBlank)) {
            return hardBlank;
        }
        return EMPTY;
    }

    private static String smushVerticalRule1(String s1, String s2) {
        if (BananaUtils.equals(s1, s2)) {
            return s1;
        }
        return EMPTY;
    }

    private static String smushVerticalRule2(String s1, String s2) {
        String rule = "|/\\[]{}()<>";
        if (BananaUtils.equals("_", s1)) {
            if (rule.contains(s2)) {
                return s2;
            }
        } else if (BananaUtils.equals("_", s2) && rule.contains(s1)) {
            return s1;
        }
        return EMPTY;
    }

    private static String smushVerticalRule3(String s1, String s2) {
        String rule = "| /\\ [] {} () <>";
        int pos1 = rule.indexOf(s1);
        int pos2 = rule.indexOf(s2);
        if (pos1 != -1 && pos2 != -1 && pos1 != pos2 && Math.abs(pos1 - pos2) != 1) {
            return BananaUtils.substr(rule, Math.max(pos1, pos2), 1);
        }
        return EMPTY;
    }

    private static String smushVerticalRule4(String s1, String s2) {
        if (BananaUtils.equals("-", s1) && BananaUtils.equals("_", s2) || BananaUtils.equals("_", s1) && BananaUtils.equals("-", s2)) {
            return "=";
        }
        return EMPTY;
    }

    private static String smushVerticalRule5(String s1, String s2) {
        if (BananaUtils.equals("|", s1) && BananaUtils.equals("|", s2)) {
            return "|";
        }
        return EMPTY;
    }

    private static String smushUniversal(String s1, String s2, String hardBlank) {
        if (BananaUtils.equals(WHITESPACE, s2) || BananaUtils.equals(EMPTY, s2)) {
            return s1;
        }
        if (BananaUtils.equals(s2, hardBlank) && !BananaUtils.equals(WHITESPACE, s1)) {
            return s1;
        }
        return s2;
    }

    private static String[] concat(String[] ... texts) {
        if (texts == null || texts.length == 0) {
            return new String[0];
        }
        int length = 0;
        for (String[] piece : texts) {
            length += piece.length;
        }
        String[] result = new String[length];
        int i = 0;
        String[][] stringArray = texts;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] piece;
            for (String s : piece = stringArray[j]) {
                result[i++] = s;
            }
        }
        return result;
    }

    private static String substr(String s, int start, int length) {
        if (BananaUtils.isEmpty(s)) {
            return EMPTY;
        }
        return s.substring(start, Math.min(start + length, s.length()));
    }

    private static String[] slice(String[] array, int start, int end) {
        String[] result = new String[end - start];
        int index = 0;
        for (int i = start; i < end; ++i) {
            result[index++] = array[i];
        }
        return result;
    }

    private static boolean isEmpty(String s) {
        return null == s || EMPTY.equals(s);
    }

    private static boolean isNotEmpty(String s) {
        return !BananaUtils.isEmpty(s);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static {
        cache = new ConcurrentHashMap<Font, Meta>();
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (int i = 32; i < 127; ++i) {
            codes.add(i);
        }
        Collections.addAll(codes, 196, 214, 220, 223, 228, 246, 252);
        CODES = Collections.unmodifiableList(codes);
    }
}

