/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtoso;
import java.lang.reflect.Field;

public final class AknElements {
    private static final ImmutableMap<String, Class<? extends AknObject>> ELEMENTS;
    public static final String AKOMANTOSO = "akomaNtoso";
    public static final String A = "a";
    public static final String ABBR = "abbr";
    public static final String ACT = "act";
    public static final String ACTIVE_MODIFICATIONS = "activeModifications";
    public static final String ACTIVE_REF = "activeRef";
    public static final String ADDRESS = "address";
    public static final String ADJOURNMENT = "adjournment";
    public static final String ADMINISTATION_OF_OATH = "administrationOfOath";
    public static final String AFFECTED_DOCUMENT = "affectedDocument";
    public static final String ALTERNATIVE_REFERENCE = "alternativeReference";
    public static final String ALINEA = "alinea";
    public static final String AMENDMENT = "amendment";
    public static final String AMENDMENT_BODY = "amendmentBody";
    public static final String AMENDMENT_CONTENT = "amendmentContent";
    public static final String AMENDMENT_HEADING = "amendmentHeading";
    public static final String AMENDMENT_JUSTIFICATION = "amendmentJustification";
    public static final String AMENDMENT_LIST = "amendmentList";
    public static final String AMENDMENT_REFERENCE = "amendmentReference";
    public static final String ANALYSIS = "analysis";
    public static final String ANSWER = "answer";
    public static final String APPLICATION = "application";
    public static final String APPLIES = "applies";
    public static final String ARGUMENT = "argument";
    public static final String ARGUMENTS = "arguments";
    public static final String ARTICLE = "article";
    public static final String ATTACHMENT = "attachment";
    public static final String ATTACHMENT_OF = "attachmentOf";
    public static final String ATTACHMENTS = "attachments";
    public static final String AUTHORIAL_NOTE = "authorialNote";
    public static final String B = "b";
    public static final String BACKGROUND = "background";
    public static final String BLOCK = "block";
    public static final String BLOCK_CONTAINER = "blockContainer";
    public static final String BLOCK_LIST = "blockList";
    public static final String BODY = "body";
    public static final String BOOK = "book";
    public static final String BR = "br";
    public static final String BILL = "bill";
    public static final String CAPTION = "caption";
    public static final String CHANGE = "change";
    public static final String CHAPTER = "chapter";
    public static final String CITATION = "citation";
    public static final String CITATIONS = "citations";
    public static final String CLASSIFICATION = "classification";
    public static final String CLAUSE = "clause";
    public static final String COLLECTION_BODY = "collectionBody";
    public static final String COMMUNICATION = "communication";
    public static final String COMPONENT = "component";
    public static final String COMPONENT_DATA = "componentData";
    public static final String COMPONENT_INFO = "componentInfo";
    public static final String COMPONENT_REF = "componentRef";
    public static final String COMPONENTS = "components";
    public static final String CONCEPT = "concept";
    public static final String CONCLUSIONS = "conclusions";
    public static final String CONDITION = "condition";
    public static final String CONTAINER = "container";
    public static final String CONTENT = "content";
    public static final String CONTRASTS = "contrasts";
    public static final String COUNT = "count";
    public static final String COURT_TYPE = "courtType";
    public static final String COVER_PAGE = "coverPage";
    public static final String CROSS_HEADING = "crossHeading";
    public static final String DATE = "date";
    public static final String DEBATE = "debate";
    public static final String DEBATE_BODY = "debateBody";
    public static final String DEBATE_REPORT = "debateReport";
    public static final String DEBATE_SECTION = "debateSection";
    public static final String DECISION = "decision";
    public static final String DECLARATION_OF_VOTE = "declarationOfVote";
    public static final String DECORATION = "decoration";
    public static final String DEF = "def";
    public static final String DEL = "del";
    public static final String DEROGATES = "derogates";
    public static final String DESTINATION = "destination";
    public static final String DISSENTS_FROM = "dissentsFrom";
    public static final String DIV = "div";
    public static final String DISTINGUISHES = "distinguishes";
    public static final String DIVISION = "division";
    public static final String DOC = "doc";
    public static final String DOC_AUTHORITY = "docAuthority";
    public static final String DOC_COMMITTEE = "docCommittee";
    public static final String DOC_DATE = "docDate";
    public static final String DOC_INTRODUCER = "docIntroducer";
    public static final String DOC_JURISDICTION = "docJurisdiction";
    public static final String DOCKET_NUMBER = "docketNumber";
    public static final String DOC_NUMBER = "docNumber";
    public static final String DOC_PROPONENT = "docProponent";
    public static final String DOC_PURPOSE = "docPurpose";
    public static final String DOC_STAGE = "docStage";
    public static final String DOC_STATUS = "docStatus";
    public static final String DOC_TITLE = "docTitle";
    public static final String DOC_TYPE = "docType";
    public static final String DOCUMENT_COLLECTION = "documentCollection";
    public static final String DOCUMENT_REF = "documentRef";
    public static final String DOMAIN = "domain";
    public static final String DURATION = "duration";
    public static final String EFFICACY = "efficacy";
    public static final String EFFICACY_MOD = "efficacyMod";
    public static final String EMBEDDED_STRUCTURE = "embeddedStructure";
    public static final String EMBEDDED_TEXT = "embeddedText";
    public static final String ENTITY = "entity";
    public static final String EOL = "eol";
    public static final String EOP = "eop";
    public static final String EVENT = "event";
    public static final String EVENT_REF = "eventRef";
    public static final String EXTENDS = "extends";
    public static final String FILL_IN = "fillIn";
    public static final String FORCE = "force";
    public static final String FORCE_MOD = "forceMod";
    public static final String FOREIGN = "foreign";
    public static final String FORMULA = "formula";
    public static final String FRBR_ALIAS = "FRBRalias";
    public static final String FRBR_AUTHOR = "FRBRauthor";
    public static final String FRBR_AUTHORITATIVE = "FRBRauthoritative";
    public static final String FRBR_COUNTRY = "FRBRcountry";
    public static final String FRBR_DATE = "FRBRdate";
    public static final String FRBR_EXPRESSION = "FRBRExpression";
    public static final String FRBR_FORMAT = "FRBRformat";
    public static final String FRBR_ITEM = "FRBRItem";
    public static final String FRBR_LANGUAGE = "FRBRlanguage";
    public static final String FRBR_MANIFESTATION = "FRBRManifestation";
    public static final String FRBR_MASTER_EXPRESSION = "FRBRmasterExpression";
    public static final String FRBR_NAME = "FRBRname";
    public static final String FRBR_NUMBER = "FRBRnumber";
    public static final String FRBR_PORTION = "FRBRportion";
    public static final String FRBR_PRESCRIPTIVE = "FRBRprescriptive";
    public static final String FRBR_SUBTYPE = "FRBRsubtype";
    public static final String FRBR_THIS = "FRBRthis";
    public static final String FRBR_TRANSLATION = "FRBRtranslation";
    public static final String FRBR_URI = "FRBRuri";
    public static final String FRBR_VERSION_NUMBER = "FRBRversionNumber";
    public static final String FRBR_WORK = "FRBRWork";
    public static final String FROM = "from";
    public static final String HAS_ATTACHMENT = "hasAttachment";
    public static final String H_CONTAINER = "hcontainer";
    public static final String HEADER = "header";
    public static final String HEADING = "heading";
    public static final String I = "i";
    public static final String IDENTIFICATION = "identification";
    public static final String IMG = "img";
    public static final String IMPLICIT_REFERENCE = "implicitReference";
    public static final String INDENT = "indent";
    public static final String INLINE = "inline";
    public static final String INS = "ins";
    public static final String INTERSTITIAL = "interstitial";
    public static final String INTRO = "intro";
    public static final String INTRODUCTION = "introduction";
    public static final String IS_ANALOG_TO = "isAnalogTo";
    public static final String ITEM = "item";
    public static final String JUDGE = "judge";
    public static final String JUDGMENT = "judgment";
    public static final String JUDGMENT_BODY = "judgmentBody";
    public static final String JUDICIAL = "judicial";
    public static final String JURISPRUDENCE = "jurisprudence";
    public static final String KEYWORD = "keyword";
    public static final String LAWYER = "lawyer";
    public static final String LEGAL_SYSTEM_MOD = "legalSystemMod";
    public static final String LEGISLATURE = "legislature";
    public static final String LEVEL = "level";
    public static final String LI = "li";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LIST = "list";
    public static final String LIST_INTRODUCTION = "listIntroduction";
    public static final String LIST_WRAP_UP = "listWrapUp";
    public static final String LOCATION = "location";
    public static final String LONG_TITLE = "longTitle";
    public static final String MAIN_BODY = "mainBody";
    public static final String MAPPING = "mapping";
    public static final String MAPPINGS = "mappings";
    public static final String MARKER = "marker";
    public static final String MEANING_MOD = "meaningMod";
    public static final String META = "meta";
    public static final String MINISTERIAL_STATEMENTS = "ministerialStatements";
    public static final String MMOD = "mmod";
    public static final String MOD = "mod";
    public static final String MOTIVATION = "motivation";
    public static final String MREF = "mref";
    public static final String NARRATIVE = "narrative";
    public static final String NATIONAL_INTEREST = "nationalInterest";
    public static final String NEUTRAL_CITATION = "neutralCitation";
    public static final String NEW = "new";
    public static final String NOTE = "note";
    public static final String NOTE_REF = "noteRef";
    public static final String NOTES = "notes";
    public static final String NOTICES_OF_MOTION = "noticesOfMotion";
    public static final String NUM = "num";
    public static final String OBJECT = "object";
    public static final String OFFICIAL_GAZETTE = "officialGazette";
    public static final String OL = "ol";
    public static final String OLD = "old";
    public static final String OMISSIS = "omissis";
    public static final String OPINION = "opinion";
    public static final String ORAL_STATEMENTS = "oralStatements";
    public static final String ORGANIZATION = "organization";
    public static final String ORIGINAL = "original";
    public static final String OTHER = "other";
    public static final String OTHER_ANALYSIS = "otherAnalysis";
    public static final String OTHER_REFERENCES = "OtherReferences";
    public static final String OUTCOME = "outcome";
    public static final String OVER_RULES = "overrules";
    public static final String P = "p";
    public static final String PAPERS = "papers";
    public static final String PARAGRAPH = "paragraph";
    public static final String PART = "part";
    public static final String PARLIAMENTARY = "parliamentary";
    public static final String PARTY = "party";
    public static final String PASSIVE_MODIFICATIONS = "passiveModifications";
    public static final String PASSIVE_REF = "passiveRef";
    public static final String PERSON = "person";
    public static final String PERSONAL_STATEMENTS = "personalStatements";
    public static final String PETITIONS = "petitions";
    public static final String PLACE_HOLDER = "placeholder";
    public static final String POINT = "point";
    public static final String POINT_OF_ORDER = "pointOfOrder";
    public static final String POPUP = "popup";
    public static final String PORTION = "portion";
    public static final String PORTION_BODY = "portionBody";
    public static final String PRAYERS = "prayers";
    public static final String PREAMBLE = "preamble";
    public static final String PREFACE = "preface";
    public static final String PRESENTATION = "presentation";
    public static final String PRESERVATION = "preservation";
    public static final String PREVIOUS = "previous";
    public static final String PROCEDURAL_MOTIONS = "proceduralMotions";
    public static final String PROCESS = "process";
    public static final String PROPRIETARY = "proprietary";
    public static final String PROVISO = "proviso";
    public static final String PUBLICATION = "publication";
    public static final String PUTS_IN_QUESTION = "putsInQuestion";
    public static final String QUANTITY = "quantity";
    public static final String QUESTION = "question";
    public static final String QUESTIONS = "questions";
    public static final String QUORUM = "quorum";
    public static final String QUORUM_VERIFICATION = "quorumVerification";
    public static final String QUOTED_STRUCTURE = "quotedStructure";
    public static final String QUOTED_TEXT = "quotedText";
    public static final String RECITAL = "recital";
    public static final String RECITALS = "recitals";
    public static final String RECORDED_TIME = "recordedTime";
    public static final String RECOUNT = "recount";
    public static final String REF = "ref";
    public static final String REFERENCES = "references";
    public static final String RELATED_DOCUMENT = "relatedDocument";
    public static final String REMARK = "remark";
    public static final String REMEDIES = "remedies";
    public static final String RESOLUTIONS = "resolutions";
    public static final String RESTRICTION = "restriction";
    public static final String RESTRICTIONS = "restrictions";
    public static final String RESTRICTS = "restricts";
    public static final String RESULT = "result";
    public static final String RMOD = "rmod";
    public static final String ROLE = "role";
    public static final String ROLL_CALL = "rollCall";
    public static final String RREF = "rref";
    public static final String RULE = "rule";
    public static final String SCENE = "scene";
    public static final String SCOPE_MOD = "scopeMod";
    public static final String SECTION = "section";
    public static final String SESSION = "session";
    public static final String SHORT_TITLE = "shortTitle";
    public static final String SIGNATURE = "signature";
    public static final String SOURCE = "source";
    public static final String SPAN = "span";
    public static final String SPEECH = "speech";
    public static final String SPEECH_GROUP = "speechGroup";
    public static final String STATEMENT = "statement";
    public static final String STEP = "step";
    public static final String SUB = "sub";
    public static final String SUB_CHAPTER = "subchapter";
    public static final String SUB_CLAUSE = "subclause";
    public static final String SUB_DIVISION = "subdivision";
    public static final String SUB_FLOW = "subFlow";
    public static final String SUB_HEADING = "subheading";
    public static final String SUB_LIST = "sublist";
    public static final String SUB_PARAGRAPH = "subparagraph";
    public static final String SUB_PART = "subpart";
    public static final String SUB_SECTION = "subsection";
    public static final String SUB_TITLE = "subtitle";
    public static final String SUB_RULE = "subrule";
    public static final String SUMMARY = "summary";
    public static final String SUP = "sup";
    public static final String SUPPORTS = "supports";
    public static final String TABLE = "table";
    public static final String TBLOCK = "tblock";
    public static final String TD = "td";
    public static final String TEMPORAL_DATA = "temporalData";
    public static final String TEMPORAL_GROUP = "temporalGroup";
    public static final String TERM = "term";
    public static final String TEXTUAL_MOD = "textualMod";
    public static final String TH = "th";
    public static final String TIME = "time";
    public static final String TIME_INTERVAL = "timeInterval";
    public static final String TITLE = "title";
    public static final String TLC_CONCEPT = "TLCConcept";
    public static final String TLC_EVENT = "TLCEvent";
    public static final String TLC_LOCATION = "TLCLocation";
    public static final String TLC_OBJECT = "TLCObject";
    public static final String TLC_ORGANIZATION = "TLCOrganization";
    public static final String TLC_PERSON = "TLCPerson";
    public static final String TLC_PROCESS = "TLCProcess";
    public static final String TLC_REFERENCE = "TLCReference";
    public static final String TLC_ROLE = "TLCRole";
    public static final String TLC_TERM = "TLCTerm";
    public static final String TOC = "toc";
    public static final String TOC_ITEM = "tocItem";
    public static final String TOME = "tome";
    public static final String TR = "tr";
    public static final String TRANSITIONAL = "transitional";
    public static final String U = "u";
    public static final String UL = "ul";
    public static final String VOTE = "vote";
    public static final String VOTING = "voting";
    public static final String WORKFLOW = "workflow";
    public static final String WRAP = "wrap";
    public static final String WRAP_UP = "wrapUp";
    public static final String WRITTEN_STATEMENTS = "writtenStatements";

    private AknElements() {
    }

    public static boolean exists(String name) {
        return ELEMENTS.containsKey((Object)name);
    }

    public static Class<? extends AknObject> getAknClass(String name) {
        return (Class)ELEMENTS.get((Object)name);
    }

    private static String firstLetterUpperCase(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(value.charAt(0)));
        if (value.length() > 1) {
            builder.append(value.substring(1));
        }
        return builder.toString();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Field field : AknElements.class.getDeclaredFields()) {
            if (!String.class.equals(field.getType())) continue;
            try {
                String value = field.get(null).toString();
                if (AKOMANTOSO.equals(value)) {
                    builder.put((Object)value, AkomaNtoso.class);
                    continue;
                }
                builder.put((Object)value, Class.forName("io.legaldocml.akn.element." + AknElements.firstLetterUpperCase(value)));
            }
            catch (Exception cause) {
                throw new IllegalStateException("Failed to get value from field [" + field + "]", cause);
            }
        }
        ELEMENTS = builder.build();
    }
}

