/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtosoContext;
import io.legaldocml.akn.AkomaNtosoType;
import io.legaldocml.akn.DocumentType;
import io.legaldocml.akn.attribute.Core;
import io.legaldocml.akn.util.AknToStringBuilder;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.diff.DiffContext;
import io.legaldocml.io.Attribute;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AkomaNtoso<T extends DocumentType>
extends AkomaNtosoType<T>
implements Core {
    private static final long ADDRESS = Buffers.address("akomaNtoso");
    private final AkomaNtosoContext context;
    private List<Attribute> attributes;

    public AkomaNtoso(AkomaNtosoContext context) {
        this.context = context;
    }

    public AkomaNtosoContext getContext() {
        return this.context;
    }

    @Override
    public void add(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(attribute);
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        writer.writeStartDocument(ADDRESS, 10);
        this.context.writeModules(writer);
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                attribute.write(writer);
            }
        }
        super.write(writer);
        writer.writeEndDocument(ADDRESS, 10);
    }

    @Override
    public String name() {
        return "akomaNtoso";
    }

    @Override
    public void accept(AknVisitor visitor) {
        if (visitor.visitEnter(this)) {
            super.accept(visitor);
            visitor.visitLeave(this);
        }
    }

    public String toString() {
        AknToStringBuilder builder = new AknToStringBuilder(this);
        builder.append(this.attributes);
        return builder.toString();
    }

    @Override
    public void nestedCompare(AknObject object, DiffContext context) {
        Core.super.nestedCompare(object, context);
        super.nestedCompare(object, context);
    }
}

