/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.attribute.Id;
import io.legaldocml.akn.attribute.Src;
import io.legaldocml.akn.type.ManifestationURI;
import io.legaldocml.akn.type.NoWhiteSpace;
import io.legaldocml.io.XmlReaderContext;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.model.ModelProvider;
import io.legaldocml.module.AknModule;
import io.legaldocml.module.Module;
import io.legaldocml.unsafe.UnsafeString;
import io.legaldocml.util.CharArray;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AkomaNtosoContext
implements XmlReaderContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AkomaNtosoContext.class);
    private static final ImmutableMap<String, BiConsumer<AkomaNtosoContext, AknObject>> REFS = ImmutableMap.builder().put((Object)"eId", (context, aknObject) -> context.eids.put(((Id)aknObject).getEid(), (Id)aknObject)).put((Object)"src", (context, aknObject) -> context.srcs.put(((Src)aknObject).getSrc(), (Src)aknObject)).build();
    private final HashMap<NoWhiteSpace, Id> eids = new HashMap();
    private final HashMap<ManifestationURI, Src> srcs = new HashMap();
    private final Map<CharArray, Module> modules = new HashMap<CharArray, Module>(4);
    private final AknModule aknModule;

    protected AkomaNtosoContext(AknModule aknModule) {
        this.aknModule = aknModule;
        this.add(aknModule);
    }

    public AknModule getAkoXmlModule() {
        return this.aknModule;
    }

    public Module getModule(CharArray array) {
        return this.modules.get(array);
    }

    void writeModules(XmlWriter writer) throws IOException {
        for (Module module : this.modules.values()) {
            module.writeNamespace(writer);
        }
    }

    public void add(Module module) {
        this.modules.put(module.namespace(), module);
    }

    public void update(String name, AknObject akn) {
        BiConsumer consumer = (BiConsumer)REFS.get((Object)name);
        if (consumer != null) {
            consumer.accept(this, akn);
        }
    }

    public Id getId(String id) {
        return this.eids.get(NoWhiteSpace.valueOf(UnsafeString.getChars(id)));
    }

    public Id getId(NoWhiteSpace id) {
        return this.eids.get(id);
    }

    public Iterator<Id> getIds() {
        return this.eids.values().iterator();
    }

    public abstract ModelProvider getModelProvider();
}

