/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.DocumentType;
import io.legaldocml.akn.element.Components;
import io.legaldocml.akn.element.Groups;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.diff.DiffContext;
import io.legaldocml.diff.Diffs;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import java.io.IOException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AkomaNtosoType<T extends DocumentType>
implements AknObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AkomaNtosoType.class);
    private T documentType;
    private Components components;

    public final T getDocumentType() {
        return this.documentType;
    }

    public final void setDocumentType(T documentType) {
        this.documentType = documentType;
    }

    public final Components getComponents() {
        return this.components;
    }

    public final void setComponents(Components components) {
        this.components = components;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        this.documentType.write(writer);
        if (this.components != null) {
            this.components.write(writer);
        }
    }

    @Override
    public void read(XmlReader reader) {
        Supplier supplier = (Supplier)Groups.getDocumentTypes(reader).get((Object)reader.getQName().getLocalName());
        if (supplier == null) {
            throw new RuntimeException("Document type not supported [" + reader.getQName().getLocalName() + "]");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("supplier found : [{}]", (Object)supplier);
        }
        this.documentType = (DocumentType)supplier.get();
        this.documentType.read(reader);
        reader.nextStartOrEndElement();
        if (reader.getEventType() != 8 && reader.getQName().equalsLocalName("components")) {
            this.components = new Components();
            this.components.read(reader);
            reader.nextStartOrEndElement();
        }
    }

    @Override
    public void accept(AknVisitor visitor) {
        if (this.documentType != null) {
            this.documentType.accept(visitor);
        }
        if (this.components != null) {
            this.components.accept(visitor);
        }
    }

    @Override
    public void nestedCompare(AknObject object, DiffContext context) {
        Diffs.compare(this.documentType, ((AkomaNtosoType)object).documentType, context);
        Diffs.compare(this.components, ((AkomaNtosoType)object).components, context);
    }
}

