/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtosoContext;
import io.legaldocml.akn.HasCoverPage;
import io.legaldocml.akn.HasPreface;
import io.legaldocml.akn.attribute.Core;
import io.legaldocml.akn.element.Attachments;
import io.legaldocml.akn.element.AttachmentsV2;
import io.legaldocml.akn.element.AttachmentsV3;
import io.legaldocml.akn.element.Components;
import io.legaldocml.akn.element.Conclusions;
import io.legaldocml.akn.element.CoverPage;
import io.legaldocml.akn.element.Meta;
import io.legaldocml.akn.element.Preface;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import java.io.IOException;

abstract class AbstractStructure
implements AknObject,
Core,
HasCoverPage,
HasPreface {
    private final Meta meta = new Meta();
    private CoverPage coverPage;
    private Preface preface;
    private Attachments attachments;
    private Conclusions conclusions;
    private Components components;

    AbstractStructure() {
    }

    public final Meta getMeta() {
        return this.meta;
    }

    @Override
    public final CoverPage getCoverPage() {
        return this.coverPage;
    }

    @Override
    public final void setCoverPage(CoverPage coverPage) {
        this.coverPage = coverPage;
    }

    @Override
    public final Preface getPreface() {
        return this.preface;
    }

    @Override
    public final void setPreface(Preface preface) {
        this.preface = preface;
    }

    public final Attachments getAttachments() {
        return this.attachments;
    }

    public final void setAttachments(Attachments attachments) {
        this.attachments = attachments;
    }

    public final Conclusions getConclusions() {
        return this.conclusions;
    }

    public final void setConclusions(Conclusions conclusions) {
        this.conclusions = conclusions;
    }

    public final Components getComponents() {
        return this.components;
    }

    public final void setComponents(Components components) {
        this.components = components;
    }

    protected final void writeMeta(XmlWriter writer) throws IOException {
        this.meta.write(writer);
    }

    protected final void writeCoverPage(XmlWriter writer) throws IOException {
        if (this.coverPage != null) {
            this.coverPage.write(writer);
        }
    }

    protected final void writeMetaCoverPagePreface(XmlWriter writer) throws IOException {
        this.meta.write(writer);
        if (this.coverPage != null) {
            this.coverPage.write(writer);
        }
        if (this.preface != null) {
            this.preface.write(writer);
        }
    }

    protected final void writeConclusionsAttachments(XmlWriter writer) throws IOException {
        if (this.conclusions != null) {
            this.conclusions.write(writer);
        }
        if (this.attachments != null) {
            this.attachments.write(writer);
        }
        if (this.components != null) {
            this.components.write(writer);
        }
    }

    protected final void readMeta(XmlReader reader) {
        this.meta.read(reader);
    }

    protected final void readCoverPage(XmlReader reader) {
        if (reader.getQName().equalsLocalName("coverPage")) {
            this.coverPage = new CoverPage();
            this.coverPage.read(reader);
            reader.nextStartOrEndElement();
        }
    }

    protected final void readMetaCoverPagePreface(XmlReader reader) {
        this.meta.read(reader);
        if (reader.getQName().equalsLocalName("coverPage")) {
            this.coverPage = new CoverPage();
            this.coverPage.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("preface")) {
            this.preface = new Preface();
            this.preface.read(reader);
            reader.nextStartOrEndElement();
        }
    }

    protected final void readConclusionsAttachments(XmlReader reader) {
        if (reader.getEventType() != 8 && reader.getQName().equalsLocalName("conclusions")) {
            this.conclusions = new Conclusions();
            this.conclusions.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getEventType() != 8 && reader.getQName().equalsLocalName("attachments")) {
            this.attachments = ((AkomaNtosoContext)reader.getContext()).getAkoXmlModule().getVersion() == 2 ? new AttachmentsV2() : new AttachmentsV3();
            this.attachments.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getEventType() != 8 && reader.getQName().equalsLocalName("components")) {
            this.components = new Components();
            this.components.read(reader);
            reader.nextStartOrEndElement();
        }
    }

    protected final void visitMeta(AknVisitor visitor) {
        Meta m = this.meta;
        if (visitor.visitEnter(m)) {
            m.accept(visitor);
            visitor.visitLeave(m);
        }
    }

    protected final void visitCoverPage(AknVisitor visitor) {
        CoverPage cp = this.coverPage;
        if (cp != null && visitor.visitEnter(cp)) {
            cp.accept(visitor);
            visitor.visitLeave(cp);
        }
    }

    protected final void visitPreface(AknVisitor visitor) {
        Preface p = this.preface;
        if (p != null && visitor.visitEnter(p)) {
            p.accept(visitor);
            visitor.visitLeave(p);
        }
    }

    protected final void visitConclusions(AknVisitor visitor) {
        Conclusions c = this.conclusions;
        if (c != null && visitor.visitEnter(c)) {
            c.accept(visitor);
            visitor.visitLeave(c);
        }
    }

    protected final void visitAttachments(AknVisitor visitor) {
        Attachments a = this.attachments;
        if (a != null && visitor.visitEnter(a)) {
            a.accept(visitor);
            visitor.visitLeave(a);
        }
    }

    protected final void visitComponents(AknVisitor visitor) {
        Components c = this.components;
        if (c != null && visitor.visitEnter(c)) {
            c.accept(visitor);
            visitor.visitLeave(c);
        }
    }
}

