/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.attribute.Source;
import io.legaldocml.akn.element.ActiveModifications;
import io.legaldocml.akn.element.Attributes;
import io.legaldocml.akn.element.Judicial;
import io.legaldocml.akn.element.Mappings;
import io.legaldocml.akn.element.OtherAnalysis;
import io.legaldocml.akn.element.OtherReferences;
import io.legaldocml.akn.element.Parliamentary;
import io.legaldocml.akn.element.PassiveModifications;
import io.legaldocml.akn.element.Restrictions;
import io.legaldocml.akn.type.AgentRef;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.util.XmlWriterHelper;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.io.AttributeGetterSetter;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.unsafe.UnsafeHelper;
import io.legaldocml.util.Streams;
import java.io.IOException;
import java.util.stream.Stream;

public final class Analysis
implements Source {
    private static final long ADDRESS_ANALYSIS = Buffers.address("analysis");
    private static final ImmutableMap<String, AttributeGetterSetter<AknObject>> ATTRIBUTES = ImmutableMap.builder().put((Object)"source", Attributes.attributeGetterSetter4AgentRef("source", UnsafeHelper.getFieldOffset(Analysis.class, "source"))).build();
    private AgentRef source;
    private ActiveModifications activeModifications;
    private PassiveModifications passiveModifications;
    private Restrictions restrictions;
    private Judicial judicial;
    private Parliamentary parliamentary;
    private Mappings mappings;
    private AknList<OtherReferences> otherReferences;
    private AknList<OtherAnalysis> otherAnalysis;

    @Override
    public AgentRef getSource() {
        return this.source;
    }

    @Override
    public void setSource(AgentRef source) {
        this.source = source;
    }

    public ActiveModifications getActiveModifications() {
        return this.activeModifications;
    }

    public void setActiveModifications(ActiveModifications activeModifications) {
        this.activeModifications = activeModifications;
    }

    public PassiveModifications getPassiveModifications() {
        return this.passiveModifications;
    }

    public void setPassiveModifications(PassiveModifications passiveModifications) {
        this.passiveModifications = passiveModifications;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    public Judicial getJudicial() {
        return this.judicial;
    }

    public void setJudicial(Judicial judicial) {
        this.judicial = judicial;
    }

    public Parliamentary getParliamentary() {
        return this.parliamentary;
    }

    public void setParliamentary(Parliamentary parliamentary) {
        this.parliamentary = parliamentary;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public Stream<OtherReferences> getOtherReferences() {
        return Streams.stream(this.otherReferences);
    }

    public Stream<OtherAnalysis> getOtherAnalysis() {
        return Streams.stream(this.otherAnalysis);
    }

    @Override
    public ImmutableMap<String, AttributeGetterSetter<AknObject>> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        writer.writeStart(ADDRESS_ANALYSIS, 8);
        XmlWriterHelper.writeSource(writer, this);
        if (this.activeModifications != null) {
            this.activeModifications.write(writer);
        }
        if (this.passiveModifications != null) {
            this.passiveModifications.write(writer);
        }
        if (this.restrictions != null) {
            this.restrictions.write(writer);
        }
        if (this.judicial != null) {
            this.judicial.write(writer);
        }
        if (this.parliamentary != null) {
            this.parliamentary.write(writer);
        }
        if (this.mappings != null) {
            this.mappings.write(writer);
        }
        if (this.otherReferences != null && this.otherReferences.size() > 0) {
            this.otherReferences.write(writer);
        }
        if (this.otherAnalysis != null && this.otherAnalysis.size() > 0) {
            this.otherAnalysis.write(writer);
        }
        writer.writeEnd(ADDRESS_ANALYSIS, 8);
    }

    @Override
    public void read(XmlReader reader) {
        Attributes.read(reader, this);
        reader.nextStartOrEndElement();
        if (reader.getQName().equalsLocalName("activeModifications")) {
            this.activeModifications = new ActiveModifications();
            this.activeModifications.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("passiveModifications")) {
            this.passiveModifications = new PassiveModifications();
            this.passiveModifications.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("restrictions")) {
            this.restrictions = new Restrictions();
            this.restrictions.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("judicial")) {
            this.judicial = new Judicial();
            this.judicial.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("parliamentary")) {
            this.parliamentary = new Parliamentary();
            this.parliamentary.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("mappings")) {
            this.mappings = new Mappings();
            this.mappings.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("OtherReferences")) {
            this.otherReferences = new AknList((AknObject[])new OtherReferences[4]);
            do {
                OtherReferences otherReferences = new OtherReferences();
                otherReferences.read(reader);
                this.otherReferences.add(otherReferences);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("OtherReferences"));
        }
        if (reader.getQName().equalsLocalName("otherAnalysis")) {
            this.otherAnalysis = new AknList((AknObject[])new OtherAnalysis[4]);
            do {
                OtherAnalysis otherAnalysis = new OtherAnalysis();
                otherAnalysis.read(reader);
                this.otherAnalysis.add(otherAnalysis);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("otherAnalysis"));
        }
    }

    @Override
    public String name() {
        return "analysis";
    }

    @Override
    public void accept(AknVisitor visitor) {
        if (visitor.visitEnter(this)) {
            visitor.visitLeave(this);
        }
    }
}

