/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtosoContext;
import io.legaldocml.akn.attribute.Core;
import io.legaldocml.akn.element.Object;
import io.legaldocml.akn.other.ExternalAttribute;
import io.legaldocml.akn.type.AgentRef;
import io.legaldocml.akn.type.ConceptRef;
import io.legaldocml.akn.type.EidRef;
import io.legaldocml.akn.type.EventRefRef;
import io.legaldocml.akn.type.ListReferenceRef;
import io.legaldocml.akn.type.ManifestationURI;
import io.legaldocml.akn.type.NoWhiteSpace;
import io.legaldocml.akn.type.ReferenceRef;
import io.legaldocml.akn.type.RoleRef;
import io.legaldocml.akn.type.TemporalGroupRef;
import io.legaldocml.akn.type.Uri;
import io.legaldocml.akn.type.VoteRef;
import io.legaldocml.akn.type.WidRef;
import io.legaldocml.io.Attribute;
import io.legaldocml.io.AttributeGetterSetter;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.module.Module;
import io.legaldocml.module.Modules;
import io.legaldocml.unsafe.UnsafeHelper;
import io.legaldocml.util.CharArray;
import io.legaldocml.util.Dates;
import io.legaldocml.util.QnameUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import sun.misc.Unsafe;

public final class Attributes {
    public static final String BREAKAT = "breakat";
    public static final long ADDRESS_ID = Buffers.address("id");
    public static final long ADDRESS_EID = Buffers.address("eId");
    public static final long ADDRESS_WID = Buffers.address("wId");
    public static final long ADDRESS_GUID = Buffers.address("GUID");
    public static final long ADDRESS_EVOLVING_ID = Buffers.address("evolvingId");
    public static final long ADDRESS_AS = Buffers.address("as");
    public static final long ADDRESS_HREF = Buffers.address("href");
    public static final long ADDRESS_DATE = Buffers.address("date");
    public static final long ADDRESS_NAME = Buffers.address("name");
    public static final long ADDRESS_VALUE = Buffers.address("value");
    public static final long ADDRESS_FROM_LANGUAGE = Buffers.address("fromLanguage");
    public static final long ADDRESS_AUTHORITATIVE = Buffers.address("authoritative");
    public static final long ADDRESS_PIVOT = Buffers.address("pivot");
    public static final long ADDRESS_BY = Buffers.address("by");
    public static final long ADDRESS_TO = Buffers.address("to");
    public static final long ADDRESS_LANGUAGE = Buffers.address("language");
    public static final long ADDRESS_REFERS = Buffers.address("refersTo");
    public static final long ADDRESS_OUTCOME = Buffers.address("outcome");
    public static final long ADDRESS_SOURCE = Buffers.address("source");
    public static final long ADDRESS_CONTAINS = Buffers.address("contains");
    public static final long ADDRESS_SHOW_AS = Buffers.address("showAs");
    public static final long ADDRESS_SHORT_FORM = Buffers.address("shortForm");
    public static final long ADDRESS_NUMBER = Buffers.address("number");
    public static final long ADDRESS_TYPE = Buffers.address("type");
    public static final long ADDRESS_ORIGINATING_EXPRESSION = Buffers.address("originatingExpression");
    public static final long ADDRESS_CLASS = Buffers.address("class");
    public static final long ADDRESS_STYLE = Buffers.address("style");
    public static final long ADDRESS_TITLE = Buffers.address("title");
    public static final long ADDRESS_DICTIONARY = Buffers.address("dictionary");
    public static final long ADDRESS_LEVEL = Buffers.address("level");
    public static final long ADDRESS_TARGET = Buffers.address("target");
    public static final long ADDRESS_CELLSPACING = Buffers.address("cellspacing");
    public static final long ADDRESS_CELLPADDING = Buffers.address("cellpadding");
    public static final long ADDRESS_BORDER = Buffers.address("border");
    public static final long ADDRESS_WIDTH = Buffers.address("width");
    public static final long ADDRESS_HEIGHT = Buffers.address("height");
    public static final long ADDRESS_STATUS = Buffers.address("status");
    public static final long ADDRESS_PERIOD = Buffers.address("period");
    public static final long ADDRESS_ALTERNATIVE_TO = Buffers.address("alternativeTo");
    public static final long ADDRESS_MARKER = Buffers.address("marker");
    public static final long ADDRESS_PLACEMENT = Buffers.address("placement");
    public static final long ADDRESS_PLACEMENT_BASE = Buffers.address("placementBase");
    public static final long ADDRESS_COL_SPAN = Buffers.address("colspan");
    public static final long ADDRESS_ROW_SPAN = Buffers.address("rowspan");
    public static final long ADDRESS_SRC = Buffers.address("src");
    public static final long ADDRESS_ALT = Buffers.address("alt");
    public static final long ADDRESS_UPTO = Buffers.address("upTo");
    public static final long ADDRESS_START = Buffers.address("start");
    public static final long ADDRESS_END = Buffers.address("end");
    public static final long ADDRESS_DURATION = Buffers.address("duration");
    public static final long ADDRESS_ACTOR = Buffers.address("actor");
    public static final long ADDRESS_ROLE = Buffers.address("as");
    public static final long ADDRESS_EXCLUSION = Buffers.address("exclusion");
    public static final long ADDRESS_INCOMPLETE = Buffers.address("incomplete");
    public static final long ADDRESS_FOR = Buffers.address("for");
    public static final long ADDRESS_FROM = Buffers.address("from");
    public static final long ADDRESS_BREAKAT = Buffers.address("breakat");
    public static final long ADDRESS_TIME = Buffers.address("time");
    public static final long ADDRESS_NORMALIZED = Buffers.address("normalized");
    public static final long ADDRESS_INCLUDED_IN = Buffers.address("includedIn");
    public static final long ADDRESS_EMPOWERED_BY = Buffers.address("empoweredBy");
    public static final long ADDRESS_STARTQUOTE = Buffers.address("startQuote");
    public static final long ADDRESS_INLINEQUOTE = Buffers.address("inlineQuote");
    public static final long ADDRESS_ENDQUOTE = Buffers.address("endQuote");
    public static final long ADDRESS_POS = Buffers.address("pos");
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();

    private Attributes() {
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4Integer(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, Integer.valueOf(charArray.toString()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4String(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, charArray.toString());
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4NoWhiteSpace(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, NoWhiteSpace.valueOf(charArray.value()));
            }
        };
    }

    public static <T extends Enum<T>, E> AttributeGetterSetter<E> attributeGetterSetter4Enum(String name, long addr, final Class<T> enumClass) {
        return new DefaultAknAttributeGetterSetter<E>(name, addr){

            @Override
            public void accept(E object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, Enum.valueOf(enumClass, charArray.toString()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4LocalDateTime(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T i, CharArray s) {
                LocalDateTime dateTime;
                try {
                    dateTime = LocalDateTime.parse(s.toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                catch (DateTimeParseException cause) {
                    throw new RuntimeException();
                }
                UnsafeHelper.getUnsafe().putObject(i, this.addr, dateTime);
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4DateTime(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T i, CharArray s) {
                OffsetDateTime dateTime;
                String val = s.toString();
                if (val.length() == 10) {
                    dateTime = OffsetDateTime.of(LocalDate.parse(s.toString(), DateTimeFormatter.ISO_DATE), Dates.TIME_00_00_00, Dates.ZONE_OFFSET_0);
                } else {
                    try {
                        dateTime = OffsetDateTime.of(LocalDateTime.parse(s.toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME), ZoneOffset.ofHours(0));
                    }
                    catch (DateTimeParseException cause) {
                        dateTime = OffsetDateTime.parse(s.toString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }
                }
                UNSAFE.putObject(i, this.addr, dateTime);
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4Boolean(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, Boolean.valueOf(charArray.toString()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4Uri(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, Uri.raw(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4ManifestationURI(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new ManifestationURI(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4ReferenceRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, ReferenceRef.raw(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4EidRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new EidRef(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4WidRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new WidRef(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4AgentRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, AgentRef.raw(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4RoleRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, RoleRef.raw(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4VoteRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new VoteRef(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4ConceptRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new ConceptRef(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4ListReferenceRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new ListReferenceRef(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4EventRefRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new EventRefRef(charArray.value()));
            }
        };
    }

    public static <T> AttributeGetterSetter<T> attributeGetterSetter4TemporalGroupRef(String name, long addr) {
        return new DefaultAknAttributeGetterSetter<T>(name, addr){

            @Override
            public void accept(T object, CharArray charArray) {
                UNSAFE.putObject(object, this.addr, new TemporalGroupRef(charArray.value()));
            }
        };
    }

    public static void read4Extension(XmlReader reader, Object akoObject) {
        reader.forEach(akoObject, (object, name, value, prefixNS) -> {
            if (prefixNS <= 0) throw new UnsupportedOperationException();
            if (!name.toString().startsWith(reader.getQName().getPrefix())) throw new UnsupportedOperationException();
            AttributeGetterSetter cons = (AttributeGetterSetter)akoObject.attributes().get((java.lang.Object)QnameUtil.localName(name));
            if (cons == null) {
                throw new RuntimeException("Missing [" + QnameUtil.localName(name) + "] for [" + akoObject.getClass().getSimpleName() + "]");
            }
            cons.accept(akoObject, value);
        });
    }

    public static void read(XmlReader reader, AknObject object) {
        reader.forEach(object, (akn, name, value, prefixNS) -> {
            if (prefixNS > 0) {
                CharArray ns = reader.getNamespaces().get(name.subSequence(0, prefixNS));
                Module module = Modules.get(ns);
                if (!(akn instanceof Core)) {
                    throw new RuntimeException("Should instance of Core");
                }
                Attribute attr = module == null ? new ExternalAttribute(name, value) : module.attributes(name.toString().substring(prefixNS + 1)).get();
                attr.read(reader, value);
                ((Core)akn).add(attr);
                return;
            }
            AttributeGetterSetter cons = (AttributeGetterSetter)akn.attributes().get((java.lang.Object)name.toString());
            if (cons == null) {
                throw new RuntimeException("Missing [" + name + "] for [" + akn.getClass().getSimpleName() + "]");
            }
            cons.accept(akn, value);
            ((AkomaNtosoContext)reader.getContext()).update(cons.name(), (AknObject)akn);
        });
    }

    private static abstract class DefaultAknAttributeGetterSetter<T>
    implements AttributeGetterSetter<T> {
        final long addr;
        private final String name;

        protected DefaultAknAttributeGetterSetter(String name, long addr) {
            this.addr = addr;
            this.name = name;
        }

        @Override
        public java.lang.Object apply(T object) {
            return UNSAFE.getObject(object, this.addr);
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

