/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.MandatoryElementException;
import io.legaldocml.akn.element.ComponentInfo;
import io.legaldocml.akn.element.FRBRalias;
import io.legaldocml.akn.element.FRBRauthor;
import io.legaldocml.akn.element.FRBRdate;
import io.legaldocml.akn.element.FRBRthis;
import io.legaldocml.akn.element.FRBRuri;
import io.legaldocml.akn.element.Preservation;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import java.io.IOException;

public abstract class CoreProperties
implements AknObject {
    private final FRBRthis frbrThis = new FRBRthis();
    private final AknList<FRBRuri> uris = new AknList((AknObject[])new FRBRuri[2]);
    private AknList<FRBRalias> aliases;
    private final FRBRdate date = new FRBRdate();
    private final AknList<FRBRauthor> authors = new AknList((AknObject[])new FRBRauthor[4]);
    private ComponentInfo componentInfo;
    private Preservation preservation;

    public final FRBRthis getFRBRthis() {
        return this.frbrThis;
    }

    public final void addFRBRuri(FRBRuri fRBRuri) {
        this.uris.add(fRBRuri);
    }

    public final FRBRdate getFRBRdate() {
        return this.date;
    }

    public final AknList<FRBRauthor> getAuthors() {
        return this.authors;
    }

    public final void add(FRBRauthor author) {
        this.authors.add(author);
    }

    public final ComponentInfo getComponentInfo() {
        return this.componentInfo;
    }

    public final void setComponentInfo(ComponentInfo componentInfo) {
        this.componentInfo = componentInfo;
    }

    public final Preservation getPreservation() {
        return this.preservation;
    }

    public final void setPreservation(Preservation preservation) {
        this.preservation = preservation;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        this.frbrThis.write(writer);
        for (FRBRuri uri : this.uris) {
            uri.write(writer);
        }
        if (this.aliases != null) {
            for (FRBRalias alias : this.aliases) {
                alias.write(writer);
            }
        }
        this.date.write(writer);
        for (FRBRauthor author : this.authors) {
            author.write(writer);
        }
        if (this.componentInfo != null) {
            this.componentInfo.write(writer);
        }
        if (this.preservation != null) {
            this.preservation.write(writer);
        }
    }

    @Override
    public void read(XmlReader reader) {
        reader.nextStartOrEndElement();
        if (!reader.getQName().equalsLocalName("FRBRthis")) {
            throw new MandatoryElementException(this, "FRBRthis", reader);
        }
        this.frbrThis.read(reader);
        reader.nextStartOrEndElement();
        if (reader.getQName().equalsLocalName("FRBRuri")) {
            do {
                FRBRuri uri = new FRBRuri();
                uri.read(reader);
                this.uris.add(uri);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("FRBRuri"));
        } else {
            throw new MandatoryElementException(this, "FRBRuri", reader);
        }
        if (reader.getQName().equalsLocalName("FRBRalias")) {
            this.aliases = new AknList((AknObject[])new FRBRalias[4]);
            do {
                FRBRalias alias = new FRBRalias();
                alias.read(reader);
                this.aliases.add(alias);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("FRBRalias"));
        }
        if (!reader.getQName().equalsLocalName("FRBRdate")) {
            throw new MandatoryElementException(this, "FRBRdate", reader);
        }
        this.date.read(reader);
        reader.nextStartOrEndElement();
        if (reader.getQName().equalsLocalName("FRBRauthor")) {
            do {
                FRBRauthor author = new FRBRauthor();
                author.read(reader);
                this.authors.add(author);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("FRBRauthor"));
        } else {
            throw new MandatoryElementException(this, "FRBRauthor", reader);
        }
        if (reader.getQName().equalsLocalName("componentInfo")) {
            this.componentInfo = new ComponentInfo();
            this.componentInfo.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("preservation")) {
            this.preservation = new Preservation();
            this.preservation.read(reader);
            reader.nextStartOrEndElement();
        }
    }

    @Override
    public void accept(AknVisitor visitor) {
        this.frbrThis.accept(visitor);
        this.uris.accept(visitor);
        if (this.aliases != null) {
            this.aliases.accept(visitor);
        }
        this.date.accept(visitor);
        this.authors.accept(visitor);
        if (this.componentInfo != null) {
            this.componentInfo.accept(visitor);
        }
        if (this.preservation != null) {
            this.preservation.accept(visitor);
        }
    }
}

