/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.element.CoreProperties;
import io.legaldocml.akn.element.FRBRauthoritative;
import io.legaldocml.akn.element.FRBRlanguage;
import io.legaldocml.akn.element.FRBRmasterExpression;
import io.legaldocml.akn.element.FRBRtranslation;
import io.legaldocml.akn.element.FRBRversionNumber;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import java.io.IOException;

public abstract class ExprProperties
extends CoreProperties {
    private FRBRversionNumber versionNumber;
    private FRBRauthoritative authoritative;
    private FRBRmasterExpression masterExpression;
    private final AknList<FRBRlanguage> languages = new AknList((AknObject[])new FRBRlanguage[2]);
    private AknList<FRBRtranslation> translations;

    public final void add(FRBRlanguage language) {
        this.languages.add(language);
    }

    public final AknList<FRBRlanguage> getLanguages() {
        return this.languages;
    }

    public final void add(FRBRtranslation translation) {
        if (this.translations == null) {
            this.translations = new AknList((AknObject[])new FRBRtranslation[4]);
        }
        this.translations.add(translation);
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        super.write(writer);
        if (this.versionNumber != null) {
            this.versionNumber.write(writer);
        }
        if (this.authoritative != null) {
            this.authoritative.write(writer);
        }
        if (this.masterExpression != null) {
            this.masterExpression.write(writer);
        }
        this.languages.write(writer);
        if (this.translations != null) {
            this.translations.write(writer);
        }
    }

    @Override
    public void read(XmlReader reader) {
        super.read(reader);
        if (reader.getQName().equalsLocalName("FRBRversionNumber")) {
            this.versionNumber = new FRBRversionNumber();
            this.versionNumber.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("FRBRauthoritative")) {
            this.authoritative = new FRBRauthoritative();
            this.authoritative.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("FRBRmasterExpression")) {
            this.masterExpression = new FRBRmasterExpression();
            this.masterExpression.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("FRBRlanguage")) {
            do {
                FRBRlanguage language = new FRBRlanguage();
                language.read(reader);
                this.languages.add(language);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("FRBRlanguage"));
        }
        if (reader.getQName().equalsLocalName("FRBRtranslation")) {
            this.translations = new AknList((AknObject[])new FRBRtranslation[4]);
            do {
                FRBRtranslation translation = new FRBRtranslation();
                translation.read(reader);
                this.translations.add(translation);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("FRBRtranslation"));
        }
    }

    @Override
    public void accept(AknVisitor visitor) {
        super.accept(visitor);
        if (this.versionNumber != null) {
            this.versionNumber.accept(visitor);
        }
        if (this.authoritative != null) {
            this.authoritative.accept(visitor);
        }
        if (this.masterExpression != null) {
            this.masterExpression.accept(visitor);
        }
        this.languages.accept(visitor);
        if (this.translations != null) {
            this.translations.accept(visitor);
        }
    }
}

