/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtosoContext;
import io.legaldocml.akn.attribute.CoreReq;
import io.legaldocml.akn.container.HierElementsContainer;
import io.legaldocml.akn.element.BaseHierarchy;
import io.legaldocml.akn.element.ComponentRef;
import io.legaldocml.akn.element.Content;
import io.legaldocml.akn.element.CrossHeading;
import io.legaldocml.akn.element.Groups;
import io.legaldocml.akn.element.HierarchyElement;
import io.legaldocml.akn.element.Intro;
import io.legaldocml.akn.element.Wrap;
import io.legaldocml.akn.element.WrapUp;
import io.legaldocml.akn.group.ANhier;
import io.legaldocml.akn.group.HierElements;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.util.XmlReaderHelper;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.diff.DiffContext;
import io.legaldocml.diff.Diffs;
import io.legaldocml.io.QName;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.util.Equals;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Hierarchy
extends BaseHierarchy
implements CoreReq,
HierElementsContainer<HierarchyElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hierarchy.class);
    public static final ImmutableMap<String, Supplier<HierarchyElement>> ELEMS = ImmutableMap.builder().putAll(Groups.convertSuper(Groups.hierElements())).put((Object)"componentRef", ComponentRef::new).put((Object)"crossHeading", CrossHeading::new).build();
    private Content content;
    private Intro intro;
    private AknList<HierarchyElement> elements;
    @Deprecated
    private Wrap wrap;
    private WrapUp wrapUp;

    public final void addHierarchyElement(HierarchyElement element) {
        if (this.elements == null) {
            this.elements = new AknList((AknObject[])new HierarchyElement[4]);
        }
        this.elements.add(element);
    }

    public final boolean removeHierarchyElement(HierarchyElement element) {
        return this.elements != null && this.elements.remove(Objects.requireNonNull(element));
    }

    @Override
    public final HierarchyElement remove(int index) {
        return (HierarchyElement)this.elements.remove(index);
    }

    @Override
    public final void add(HierElements hier) {
        this.addHierarchyElement(hier);
    }

    @Override
    public boolean remove(HierElements hier) {
        return this.removeHierarchyElement(hier);
    }

    @Override
    public final void add(ANhier hier) {
        this.addHierarchyElement(hier);
    }

    @Override
    public Stream<HierarchyElement> stream() {
        return this.elements == null ? Stream.empty() : this.elements.stream();
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        CoreReq.super.write(writer);
        super.write(writer);
        if (this.content != null) {
            this.content.write(writer);
        } else {
            if (this.intro != null) {
                this.intro.write(writer);
            }
            if (this.elements != null && this.elements.size() > 0) {
                this.elements.write(writer);
            }
            if (writer.getVersion() == 2) {
                if (this.wrap != null) {
                    this.wrap.write(writer);
                }
            } else if (this.wrapUp != null) {
                this.wrapUp.write(writer);
            }
        }
    }

    @Override
    public void read(XmlReader reader) {
        QName qName = reader.getQName();
        super.read(reader);
        if (reader.getQName().equalsLocalName("content")) {
            this.content = new Content();
            this.content.read(reader);
            reader.nextStartOrEndElement();
            return;
        }
        if (reader.getQName().equalsLocalName("intro")) {
            this.intro = new Intro();
            this.intro.read(reader);
            reader.nextStartOrEndElement();
        }
        this.elements = new AknList((AknObject[])new HierarchyElement[4]);
        if (((AkomaNtosoContext)reader.getContext()).getAkoXmlModule().getVersion() == 2) {
            XmlReaderHelper.read(reader, this.elements, ELEMS, qName, "wrap");
            if (reader.getEventType() == 1 && reader.getQName().equalsLocalName("wrap")) {
                this.wrap = new Wrap();
                this.wrap.read(reader);
                reader.nextStartOrEndElement();
            }
        } else {
            XmlReaderHelper.read(reader, this.elements, ELEMS, qName, "wrapUp");
            if (reader.getEventType() == 1 && reader.getQName().equalsLocalName("wrapUp")) {
                this.wrapUp = new WrapUp();
                this.wrapUp.read(reader);
                reader.nextStartOrEndElement();
            }
        }
    }

    public final Content getContent() {
        return this.content;
    }

    public final void setContent(Content content) {
        this.content = content;
    }

    public final void setIntro(Intro intro) {
        this.intro = intro;
    }

    public final Intro getIntro() {
        return this.intro;
    }

    @Override
    public void accept(AknVisitor visitor) {
        if (this.content != null) {
            this.content.accept(visitor);
        } else {
            if (this.intro != null) {
                this.intro.accept(visitor);
            }
            if (this.elements != null) {
                this.elements.accept(visitor);
            }
            if (this.wrapUp != null) {
                this.wrapUp.accept(visitor);
            }
        }
    }

    public boolean equals(Object obj) {
        return Equals.doEquals(this, obj);
    }

    @Override
    public void nestedCompare(AknObject object, DiffContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("nested Compare left=[{}], right=[{}] ", (Object)this, (Object)object);
        }
        Hierarchy hierarchy = (Hierarchy)object;
        Diffs.compareNullable(this.elements, hierarchy.elements, context);
    }
}

