/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.attribute.Source;
import io.legaldocml.akn.element.Attributes;
import io.legaldocml.akn.element.FRBRExpression;
import io.legaldocml.akn.element.FRBRItem;
import io.legaldocml.akn.element.FRBRManifestation;
import io.legaldocml.akn.element.FRBRWork;
import io.legaldocml.akn.type.AgentRef;
import io.legaldocml.akn.util.XmlWriterHelper;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.io.AttributeGetterSetter;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.unsafe.UnsafeHelper;
import java.io.IOException;

public final class Identification
implements AknObject,
Source {
    private static final long ADDRESS_IDENTIFICATION = Buffers.address("identification");
    private static final ImmutableMap<String, AttributeGetterSetter<AknObject>> ATTRIBUTES = ImmutableMap.builder().put((Object)"source", Attributes.attributeGetterSetter4AgentRef("source", UnsafeHelper.getFieldOffset(Identification.class, "source"))).build();
    private final FRBRWork work = new FRBRWork();
    private final FRBRExpression expression = new FRBRExpression();
    private final FRBRManifestation manifestation = new FRBRManifestation();
    private FRBRItem item;
    private AgentRef source;

    public FRBRWork getFRBRWork() {
        return this.work;
    }

    public FRBRExpression getFRBRExpression() {
        return this.expression;
    }

    public FRBRManifestation getFRBRManifestation() {
        return this.manifestation;
    }

    public FRBRItem getFRBRItem() {
        return this.item;
    }

    public void setFRBRItem(FRBRItem fRBRItem) {
        this.item = fRBRItem;
    }

    @Override
    public AgentRef getSource() {
        return this.source;
    }

    @Override
    public void setSource(AgentRef source) {
        this.source = source;
    }

    @Override
    public String name() {
        return "identification";
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        writer.writeStart(ADDRESS_IDENTIFICATION, 14);
        XmlWriterHelper.writeSource(writer, this);
        this.work.write(writer);
        this.expression.write(writer);
        this.manifestation.write(writer);
        if (this.item != null) {
            this.item.write(writer);
        }
        writer.writeEnd(ADDRESS_IDENTIFICATION, 14);
    }

    @Override
    public void read(XmlReader reader) {
        Attributes.read(reader, this);
        reader.nextStartOrEndElement();
        if (reader.getQName().equalsLocalName("FRBRWork")) {
            this.work.read(reader);
        }
        if (reader.getQName().equalsLocalName("FRBRExpression")) {
            this.expression.read(reader);
        }
        if (reader.getQName().equalsLocalName("FRBRManifestation")) {
            this.manifestation.read(reader);
        }
        if (reader.getQName().equalsLocalName("FRBRItem")) {
            this.item = new FRBRItem();
            this.item.read(reader);
        }
        if (!reader.getQName().equalsLocalName("identification")) {
            throw new IllegalStateException();
        }
        reader.nextStartOrEndElement();
    }

    @Override
    public ImmutableMap<String, AttributeGetterSetter<AknObject>> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public void accept(AknVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.work.accept(visitor);
            this.expression.accept(visitor);
            this.manifestation.accept(visitor);
            if (this.item != null) {
                this.item.accept(visitor);
            }
            visitor.visitLeave(this);
        }
    }
}

