/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.container.InlineCMContainer;
import io.legaldocml.akn.element.AbstractCore;
import io.legaldocml.akn.element.Groups;
import io.legaldocml.akn.element.StringInlineCM;
import io.legaldocml.akn.group.ANinline;
import io.legaldocml.akn.group.ANmarker;
import io.legaldocml.akn.group.ANtitleInline;
import io.legaldocml.akn.group.HTMLinline;
import io.legaldocml.akn.group.InlineCM;
import io.legaldocml.akn.group.SubFlowElements;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.io.Externalizable;
import io.legaldocml.io.QName;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class InlineTypeAbstract
extends AbstractCore
implements InlineCMContainer {
    private final AknList<InlineCM> data = new AknList((AknObject[])new InlineCM[8]);
    private static final ImmutableMap<String, Supplier<InlineCM>> ELEMS = ImmutableMap.builder().putAll(Groups.convert(Groups.inlineCM())).build();

    public final InlineCM remove(int index) {
        return (InlineCM)this.data.remove(index);
    }

    @Override
    public final void add(InlineCM inlineCM) {
        this.data.add((InlineCM)((Externalizable)Objects.requireNonNull(inlineCM)));
    }

    @Override
    public final void add(SubFlowElements subFlowElements) {
        this.data.add((InlineCM)((Externalizable)Objects.requireNonNull(subFlowElements)));
    }

    @Override
    public void add(ANtitleInline titleInline) {
        this.data.add((InlineCM)((Externalizable)Objects.requireNonNull(titleInline)));
    }

    @Override
    public void add(HTMLinline htmLinline) {
        this.data.add((InlineCM)((Externalizable)Objects.requireNonNull(htmLinline)));
    }

    @Override
    public void add(ANinline inline) {
        this.data.add((InlineCM)((Externalizable)Objects.requireNonNull(inline)));
    }

    @Override
    public void add(ANmarker marker) {
        this.data.add((InlineCM)((Externalizable)Objects.requireNonNull(marker)));
    }

    @Override
    public void read(XmlReader reader) {
        super.read(reader);
        InlineTypeAbstract.read(reader, this.data);
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        this.data.write(writer);
    }

    protected final AknList<InlineCM> getData() {
        return this.data;
    }

    static void read(XmlReader reader, AknList<InlineCM> data) {
        QName qName = reader.getQName();
        while (true) {
            int eventType;
            if ((eventType = reader.next()) == 1) {
                Supplier inlineCMSupplier = (Supplier)ELEMS.get((Object)reader.getQName().getLocalName());
                if (inlineCMSupplier == null) {
                    throw new RuntimeException(qName + " --> [" + reader.getQName() + "]");
                }
                InlineCM inlineCM = (InlineCM)inlineCMSupplier.get();
                inlineCM.read(reader);
                data.add(inlineCM);
                continue;
            }
            if (eventType == 4) {
                char[] content = reader.getText().value();
                if (content == null || content.length <= 0) continue;
                data.add(new StringInlineCM(content));
                continue;
            }
            if (eventType != 3 && eventType == 2 && qName.equals(reader.getQName())) break;
        }
    }
}

