/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.element.Analysis;
import io.legaldocml.akn.element.Classification;
import io.legaldocml.akn.element.Identification;
import io.legaldocml.akn.element.Lifecycle;
import io.legaldocml.akn.element.Notes;
import io.legaldocml.akn.element.Presentation;
import io.legaldocml.akn.element.Proprietary;
import io.legaldocml.akn.element.Publication;
import io.legaldocml.akn.element.References;
import io.legaldocml.akn.element.TemporalData;
import io.legaldocml.akn.element.Workflow;
import io.legaldocml.akn.type.AgentRef;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.diff.DiffContext;
import io.legaldocml.diff.Diffs;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.util.Streams;
import java.io.IOException;
import java.util.stream.Stream;

public final class Meta
implements AknObject {
    private static final long ADDRESS_META = Buffers.address("meta");
    private final Identification identification = new Identification();
    private Publication publication;
    private AknList<Classification> classifications;
    private AknList<Lifecycle> lifecycles;
    private AknList<Workflow> workflows;
    private AknList<Analysis> analysis;
    private AknList<TemporalData> temporalData;
    private AknList<References> references;
    private AknList<Notes> notes;
    private AknList<Proprietary> proprietaries;
    private AknList<Presentation> presentations;

    public Identification getIdentification() {
        return this.identification;
    }

    public Publication getPublication() {
        return this.publication;
    }

    public Stream<Classification> getClassifications() {
        return Streams.stream(this.classifications);
    }

    public Stream<Lifecycle> getLifecycles() {
        return Streams.stream(this.lifecycles);
    }

    public Stream<Workflow> getWorkflows() {
        return Streams.stream(this.workflows);
    }

    public Stream<Analysis> getAnalysis() {
        return Streams.stream(this.analysis);
    }

    public Stream<TemporalData> getTemporalData() {
        return Streams.stream(this.temporalData);
    }

    public Stream<Notes> getNotes() {
        return Streams.stream(this.notes);
    }

    public Stream<Proprietary> getProprietaries() {
        return Streams.stream(this.proprietaries);
    }

    public Stream<Presentation> getPresentations() {
        return Streams.stream(this.presentations);
    }

    public Stream<References> getReferences() {
        return Streams.stream(this.references);
    }

    public References getReferences(AgentRef source) {
        if (this.references == null) {
            return null;
        }
        for (References ref : this.references) {
            if (!source.equals(ref.getSource())) continue;
            return ref;
        }
        return null;
    }

    public void add(References references) {
        if (this.references == null) {
            this.references = new AknList((AknObject[])new References[2]);
        }
        this.references.add(references);
    }

    @Override
    public String name() {
        return "meta";
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        writer.writeStart(ADDRESS_META, 4);
        this.identification.write(writer);
        if (this.publication != null) {
            this.publication.write(writer);
        }
        if (this.classifications != null) {
            this.classifications.write(writer);
        }
        if (this.lifecycles != null) {
            this.lifecycles.write(writer);
        }
        if (this.workflows != null) {
            this.workflows.write(writer);
        }
        if (this.analysis != null && this.analysis.size() > 0) {
            this.analysis.write(writer);
        }
        if (this.temporalData != null && this.temporalData.size() > 0) {
            this.temporalData.write(writer);
        }
        if (this.references != null && this.references.size() > 0) {
            this.references.write(writer);
        }
        if (this.notes != null && this.notes.size() > 0) {
            this.notes.write(writer);
        }
        if (this.proprietaries != null && this.proprietaries.size() > 0) {
            this.proprietaries.write(writer);
        }
        writer.writeEnd(ADDRESS_META, 4);
    }

    @Override
    public void read(XmlReader reader) {
        reader.nextStartOrEndElement();
        this.identification.read(reader);
        if (reader.getQName().equalsLocalName("publication")) {
            this.publication = new Publication();
            this.publication.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("classification")) {
            this.classifications = new AknList((AknObject[])new Classification[4]);
            do {
                Classification classification = new Classification();
                classification.read(reader);
                this.classifications.add(classification);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("classification"));
        }
        if (reader.getQName().equalsLocalName("lifecycle")) {
            this.lifecycles = new AknList((AknObject[])new Lifecycle[4]);
            do {
                Lifecycle lifecycle = new Lifecycle();
                lifecycle.read(reader);
                this.lifecycles.add(lifecycle);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("lifecycle"));
        }
        if (reader.getQName().equalsLocalName("workflow")) {
            this.workflows = new AknList((AknObject[])new Workflow[4]);
            do {
                Workflow workflow = new Workflow();
                workflow.read(reader);
                this.workflows.add(workflow);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("workflow"));
        }
        if (reader.getQName().equalsLocalName("analysis")) {
            this.analysis = new AknList((AknObject[])new Analysis[4]);
            do {
                Analysis analysis = new Analysis();
                analysis.read(reader);
                this.analysis.add(analysis);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("analysis"));
        }
        if (reader.getQName().equalsLocalName("temporalData")) {
            this.temporalData = new AknList((AknObject[])new TemporalData[4]);
            do {
                TemporalData temporalData = new TemporalData();
                temporalData.read(reader);
                this.temporalData.add(temporalData);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("temporalData"));
        }
        if (reader.getQName().equalsLocalName("references")) {
            this.references = new AknList((AknObject[])new References[2]);
            do {
                References ref = new References();
                ref.read(reader);
                this.references.add(ref);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("references"));
        }
        if (reader.getQName().equalsLocalName("notes")) {
            this.notes = new AknList((AknObject[])new Notes[4]);
            do {
                Notes notes = new Notes();
                notes.read(reader);
                this.notes.add(notes);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("notes"));
        }
        if (reader.getQName().equalsLocalName("proprietary")) {
            this.proprietaries = new AknList((AknObject[])new Proprietary[4]);
            do {
                Proprietary proprietary = new Proprietary();
                proprietary.read(reader);
                this.proprietaries.add(proprietary);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("proprietary"));
        }
        if (reader.getQName().equalsLocalName("presentation")) {
            this.presentations = new AknList((AknObject[])new Presentation[4]);
            do {
                Presentation presentation = new Presentation();
                presentation.read(reader);
                this.presentations.add(presentation);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("presentation"));
        }
        if (reader.getEventType() == 2 && reader.getQName().equalsLocalName("meta")) {
            reader.nextStartOrEndElement();
        }
    }

    @Override
    public void accept(AknVisitor visitor) {
        this.identification.accept(visitor);
        if (this.publication != null) {
            this.publication.accept(visitor);
        }
        if (this.classifications != null) {
            this.classifications.accept(visitor);
        }
        if (this.lifecycles != null) {
            this.lifecycles.accept(visitor);
        }
        if (this.workflows != null) {
            this.workflows.accept(visitor);
        }
        if (this.analysis != null) {
            this.analysis.accept(visitor);
        }
        if (this.temporalData != null) {
            this.temporalData.accept(visitor);
        }
        if (this.references != null) {
            this.references.accept(visitor);
        }
        if (this.notes != null) {
            this.notes.accept(visitor);
        }
        if (this.proprietaries != null) {
            this.proprietaries.accept(visitor);
        }
        if (this.presentations != null) {
            this.presentations.accept(visitor);
        }
    }

    @Override
    public void nestedCompare(AknObject object, DiffContext context) {
        Meta meta = (Meta)object;
        Diffs.compare(this.identification, meta.identification, context);
        Diffs.compare(this.publication, meta.publication, context);
        Diffs.compareNullable(this.classifications, meta.classifications, context);
        Diffs.compareNullable(this.lifecycles, meta.lifecycles, context);
        Diffs.compareNullable(this.workflows, meta.workflows, context);
        Diffs.compareNullable(this.analysis, meta.analysis, context);
        Diffs.compareNullable(this.temporalData, meta.temporalData, context);
        Diffs.compareNullable(this.references, meta.references, context);
        Diffs.compareNullable(this.notes, meta.notes, context);
        Diffs.compareNullable(this.proprietaries, meta.proprietaries, context);
        Diffs.compareNullable(this.presentations, meta.presentations, context);
    }
}

