/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.attribute.Core;
import io.legaldocml.akn.attribute.Enactment;
import io.legaldocml.akn.attribute.IdReq;
import io.legaldocml.akn.attribute.Modifiers;
import io.legaldocml.akn.attribute.RefersOpt;
import io.legaldocml.akn.element.AbstractId;
import io.legaldocml.akn.element.Application;
import io.legaldocml.akn.element.Attributes;
import io.legaldocml.akn.element.Condition;
import io.legaldocml.akn.element.Destination;
import io.legaldocml.akn.element.Duration;
import io.legaldocml.akn.element.Efficacy;
import io.legaldocml.akn.element.Force;
import io.legaldocml.akn.element.Source;
import io.legaldocml.akn.type.ListReferenceRef;
import io.legaldocml.akn.type.StatusType;
import io.legaldocml.akn.type.TemporalGroupRef;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.util.XmlWriterHelper;
import io.legaldocml.io.AttributeGetterSetter;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.unsafe.UnsafeHelper;
import java.io.IOException;

public abstract class ModificationType
extends AbstractId
implements Core,
IdReq,
Enactment,
Modifiers,
RefersOpt {
    protected static final ImmutableMap<String, AttributeGetterSetter<AknObject>> ATTRIBUTES = ImmutableMap.builder().putAll(AbstractId.ATTRIBUTES).put((Object)"status", Attributes.attributeGetterSetter4Enum("status", UnsafeHelper.getFieldOffset(ModificationType.class, "statusType"), StatusType.class)).put((Object)"period", Attributes.attributeGetterSetter4TemporalGroupRef("period", UnsafeHelper.getFieldOffset(ModificationType.class, "period"))).put((Object)"refersTo", Attributes.attributeGetterSetter4ListReferenceRef("refersTo", UnsafeHelper.getFieldOffset(ModificationType.class, "refersTo"))).put((Object)"exclusion", Attributes.attributeGetterSetter4Boolean("exclusion", UnsafeHelper.getFieldOffset(ModificationType.class, "exclusion"))).put((Object)"incomplete", Attributes.attributeGetterSetter4Boolean("incomplete", UnsafeHelper.getFieldOffset(ModificationType.class, "incomplete"))).build();
    private TemporalGroupRef period;
    private StatusType statusType;
    private ListReferenceRef refersTo;
    private Boolean exclusion;
    private Boolean incomplete;
    private final AknList<Source> sources = new AknList((AknObject[])new Source[2]);
    private final AknList<Destination> destinations = new AknList((AknObject[])new Destination[2]);
    private Force force;
    private Efficacy efficacy;
    private Application application;
    private Duration duration;
    private Condition condition;

    @Override
    public ListReferenceRef getRefersTo() {
        return this.refersTo;
    }

    @Override
    public void setRefersTo(ListReferenceRef refersTo) {
        this.refersTo = refersTo;
    }

    @Override
    public StatusType getStatus() {
        return this.statusType;
    }

    @Override
    public void setStatus(StatusType status) {
        this.statusType = status;
    }

    @Override
    public TemporalGroupRef getPeriod() {
        return this.period;
    }

    @Override
    public void setPeriod(TemporalGroupRef period) {
        this.period = period;
    }

    @Override
    public Boolean getExclusion() {
        return this.exclusion;
    }

    @Override
    public void setExclusion(Boolean exclusion) {
        this.exclusion = exclusion;
    }

    @Override
    public Boolean getIncomplete() {
        return this.incomplete;
    }

    @Override
    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    public void addSource(Source source) {
        this.sources.add(source);
    }

    public void addDestination(Destination destination) {
        this.destinations.add(destination);
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        IdReq.super.write(writer);
        Core.super.write(writer);
        XmlWriterHelper.writeRefers(writer, this);
        XmlWriterHelper.writeEnactment(writer, this);
        XmlWriterHelper.writeModifiers(writer, this);
        this.sources.write(writer);
        this.destinations.write(writer);
        if (this.force != null) {
            this.force.write(writer);
        }
        if (this.efficacy != null) {
            this.efficacy.write(writer);
        }
        if (this.application != null) {
            this.application.write(writer);
        }
        if (this.duration != null) {
            this.duration.write(writer);
        }
        if (this.condition != null) {
            this.condition.write(writer);
        }
    }

    @Override
    public void read(XmlReader reader) {
        super.read(reader);
        reader.nextStartOrEndElement();
        if (reader.getQName().equalsLocalName("source")) {
            do {
                Source source = new Source();
                source.read(reader);
                this.sources.add(source);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("source"));
        }
        if (reader.getQName().equalsLocalName("destination")) {
            do {
                Destination destination = new Destination();
                destination.read(reader);
                this.destinations.add(destination);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("destination"));
        }
        if (reader.getQName().equalsLocalName("force")) {
            this.force = new Force();
            this.force.read(reader);
        }
        if (reader.getQName().equalsLocalName("efficacy")) {
            this.efficacy = new Efficacy();
            this.efficacy.read(reader);
        }
        if (reader.getQName().equalsLocalName("application")) {
            this.application = new Application();
            this.application.read(reader);
        }
        if (reader.getQName().equalsLocalName("duration")) {
            this.duration = new Duration();
            this.duration.read(reader);
        }
        if (reader.getQName().equalsLocalName("condition")) {
            this.condition = new Condition();
            this.condition.read(reader);
        }
    }

    @Override
    public ImmutableMap<String, AttributeGetterSetter<AknObject>> attributes() {
        return ATTRIBUTES;
    }
}

