/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.element;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.attribute.CoreReq;
import io.legaldocml.akn.attribute.TableAtts;
import io.legaldocml.akn.element.AbstractCore;
import io.legaldocml.akn.element.Attributes;
import io.legaldocml.akn.element.Blocksopt;
import io.legaldocml.akn.element.Caption;
import io.legaldocml.akn.element.Tr;
import io.legaldocml.akn.group.HTMLblock;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.akn.util.XmlWriterHelper;
import io.legaldocml.akn.visitor.AknVisitor;
import io.legaldocml.io.AttributeGetterSetter;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.unsafe.UnsafeHelper;
import java.io.IOException;
import java.util.Map;

public final class Table
extends AbstractCore
implements CoreReq,
TableAtts,
HTMLblock {
    private static final long ADDRESS_TABLE = Buffers.address("table");
    private static final ImmutableMap<String, AttributeGetterSetter<AknObject>> ATTRIBUTES = ImmutableMap.builder().putAll((Map)Blocksopt.ATTRIBUTES).put((Object)"width", Attributes.attributeGetterSetter4Integer("width", UnsafeHelper.getFieldOffset(Table.class, "width"))).put((Object)"border", Attributes.attributeGetterSetter4Integer("width", UnsafeHelper.getFieldOffset(Table.class, "border"))).put((Object)"cellspacing", Attributes.attributeGetterSetter4Integer("cellspacing", UnsafeHelper.getFieldOffset(Table.class, "cellspacing"))).put((Object)"cellpadding", Attributes.attributeGetterSetter4Integer("cellpadding", UnsafeHelper.getFieldOffset(Table.class, "cellpadding"))).build();
    private final AknList<Tr> trs = new AknList((AknObject[])new Tr[4]);
    private Caption caption;
    private Integer width;
    private Integer border;
    private Integer cellspacing;
    private Integer cellpadding;

    public Caption getCaption() {
        return this.caption;
    }

    public void setCaption(Caption caption) {
        this.caption = caption;
    }

    public void add(Tr tr) {
        this.trs.add(tr);
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(Integer width) {
        this.width = width;
    }

    @Override
    public Integer getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Integer border) {
        this.border = border;
    }

    @Override
    public Integer getCellspacing() {
        return this.cellspacing;
    }

    @Override
    public void setCellspacing(Integer cellspacing) {
        this.cellspacing = cellspacing;
    }

    @Override
    public Integer getCellpadding() {
        return this.cellpadding;
    }

    @Override
    public void setCellpadding(Integer cellpadding) {
        this.cellpadding = cellpadding;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        writer.writeStart(ADDRESS_TABLE, 5);
        XmlWriterHelper.writeTableAtts(writer, this);
        CoreReq.super.write(writer);
        if (this.caption != null) {
            this.caption.write(writer);
        }
        this.trs.write(writer);
        writer.writeEnd(ADDRESS_TABLE, 5);
    }

    @Override
    public void read(XmlReader reader) {
        super.read(reader);
        reader.nextStartOrEndElement();
        if (reader.getQName().equalsLocalName("caption")) {
            this.caption = new Caption();
            this.caption.read(reader);
            reader.nextStartOrEndElement();
        }
        if (reader.getQName().equalsLocalName("tr")) {
            do {
                Tr tr = new Tr();
                tr.read(reader);
                this.trs.add(tr);
                reader.nextStartOrEndElement();
            } while (reader.getQName().equalsLocalName("tr"));
        }
    }

    @Override
    public String name() {
        return "table";
    }

    @Override
    public ImmutableMap<String, AttributeGetterSetter<AknObject>> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public void accept(AknVisitor visitor) {
        if (visitor.visitEnter(this)) {
            if (this.caption != null) {
                this.caption.accept(visitor);
            }
            this.trs.accept(visitor);
            visitor.visitLeave(this);
        }
    }
}

