/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.other;

import io.legaldocml.akn.element.AnyOtherTypeElement;
import io.legaldocml.akn.other.ExternalAttribute;
import io.legaldocml.io.QName;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.util.CharArray;
import io.legaldocml.util.StringWriterTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalElementWithNS
implements AnyOtherTypeElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalElementWithNS.class);
    private final QName qName;
    private final CharArray namespace;
    private List<ExternalAttribute> attributes = new ArrayList<ExternalAttribute>(2);

    public ExternalElementWithNS(QName qName, CharArray namespace) {
        this.qName = qName;
        this.namespace = namespace;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        StringWriterTemplate.writeElement(writer, this.qName.toString(), w -> {
            try {
                StringWriterTemplate.writeAttribute(w, "xmlns:".concat(this.qName.getPrefix()), this.namespace.value());
                if (this.attributes != null) {
                    for (ExternalAttribute attribute : this.attributes) {
                        attribute.write(writer);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to write attribute [{}]", (Object)this.qName);
            }
        });
    }

    @Override
    public void read(XmlReader reader) {
        reader.forEach(this, (object, name, value, prefixNS) -> {
            LOGGER.debug("read attributes [{}]->[{}]->[{}]", new Object[]{name, value, prefixNS});
            if (prefixNS != 0) {
                throw new UnsupportedOperationException();
            }
            this.attributes.add(new ExternalAttribute(name, value));
        });
        reader.nextStartOrEndElement();
    }

    @Override
    public String name() {
        return this.qName.toString();
    }
}

