/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.other;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.element.AnyOtherTypeElement;
import io.legaldocml.akn.element.StringInlineCM;
import io.legaldocml.akn.other.ExternalAttribute;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.io.QName;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.util.StringWriterTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleExternalElement
implements AnyOtherTypeElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleExternalElement.class);
    private final String prefix;
    private final String localName;
    private final AknList<StringInlineCM> data = new AknList((AknObject[])new StringInlineCM[2]);
    private List<ExternalAttribute> attributes = new ArrayList<ExternalAttribute>(2);

    public SimpleExternalElement(String prefix, String localName) {
        this.prefix = prefix;
        this.localName = localName;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        StringBuilder builder = new StringBuilder(this.prefix).append(':').append(this.localName);
        StringWriterTemplate.writeElement(writer, builder.toString(), w -> {
            if (this.attributes != null) {
                for (ExternalAttribute attribute : this.attributes) {
                    try {
                        attribute.write(writer);
                    }
                    catch (IOException cause) {
                        LOGGER.error("Failed to write external attribute [" + attribute + "]", (Throwable)cause);
                    }
                }
            }
            try {
                this.data.write(writer);
            }
            catch (IOException cause) {
                LOGGER.error("Failed to write content [" + this.data + "]", (Throwable)cause);
            }
        });
    }

    @Override
    public void read(XmlReader reader) {
        QName qname = reader.getQName();
        reader.forEach(this, (object, name, value, prefixNS) -> {
            if (prefixNS != 0) {
                throw new UnsupportedOperationException();
            }
            this.attributes.add(new ExternalAttribute(name, value));
        });
        while (true) {
            int eventType;
            if ((eventType = reader.next()) == 1) {
                throw new UnsupportedOperationException("External tag inside external tag => create module");
            }
            if (eventType == 4) {
                char[] content = reader.getText().value();
                if (content == null || content.length <= 0) continue;
                this.data.add(new StringInlineCM(content));
                continue;
            }
            if (eventType == 2 && qname.equals(reader.getQName())) break;
        }
    }

    @Override
    public String name() {
        return this.localName;
    }
}

