/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.type;

import io.legaldocml.akn.type.AbstractRef;
import io.legaldocml.akn.type.RoleRef;
import io.legaldocml.akn.type.Uri;
import io.legaldocml.unsafe.UnsafeString;
import java.util.Arrays;

public final class NoWhiteSpace {
    private final char[] value;
    private int hash;

    private NoWhiteSpace(char[] value) {
        this.value = value;
    }

    private NoWhiteSpace(String id) {
        this.value = UnsafeString.getChars(id);
    }

    public char[] getChars() {
        return this.value;
    }

    public Uri toUri() {
        return AbstractRef.valueOf(this.value, Uri.INSTANTIATOR_URI);
    }

    public RoleRef toRoleRef() {
        return AbstractRef.valueOf(this.value, RoleRef.INSTANTIATOR_ROLE_REF);
    }

    public char[] makeRef() {
        char[] ref = new char[this.value.length + 1];
        ref[0] = 35;
        System.arraycopy(this.value, 0, ref, 1, this.value.length);
        return ref;
    }

    public String toString() {
        return UnsafeString.valueOf(this.value);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.value, ((NoWhiteSpace)o).value);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.value.length > 0) {
            char[] val = this.value;
            for (int i = 0; i < this.value.length; ++i) {
                h = 31 * h + val[i];
            }
            this.hash = h;
        }
        return h;
    }

    public static NoWhiteSpace valueOf(char[] value) {
        return new NoWhiteSpace(value);
    }

    public static NoWhiteSpace valueOf(String value) {
        return new NoWhiteSpace(UnsafeString.getChars(value));
    }
}

