/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.util;

import io.legaldocml.io.Externalizable;
import io.legaldocml.io.XmlWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExternalizableList<E extends Externalizable>
implements List<E> {
    private static final int MAX_ARRAY_SIZE = 0x3FFFFFFF;
    private static final int DEFAULT_CAPACITY = 8;
    private static final Externalizable[] EMPTY_ELEMENTDATA = new Externalizable[0];
    private transient E[] elems;
    private int size;
    private transient int modCount = 0;

    public ExternalizableList() {
        this.elems = EMPTY_ELEMENTDATA;
    }

    public ExternalizableList(E[] elem) {
        this.elems = elem;
        this.size = 0;
    }

    @Override
    public final boolean add(E item) {
        this.ensureCapacityInternal(this.size + 1);
        this.elems[this.size++] = item;
        return true;
    }

    @Override
    public final void add(int index, E item) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elems, index, this.elems, index + 1, this.size - index);
        this.elems[index] = item;
        ++this.size;
    }

    @Override
    public final E get(int index) {
        return this.elems[index];
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("set(int index, E element)");
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public void write(XmlWriter writer) throws IOException {
        E[] el = this.elems;
        int si = this.size;
        for (int i = 0; i < si; ++i) {
            el[i].write(writer);
        }
    }

    @Override
    public final Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.elems, 0, this.size, 80), false);
    }

    @Override
    public final void forEach(Consumer<? super E> action) {
        E[] el = this.elems;
        int si = this.size;
        for (int i = 0; i < si; ++i) {
            action.accept(el[i]);
        }
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean remove(Object o) {
        E[] el = this.elems;
        int si = this.size;
        for (int i = 0; i < si; ++i) {
            if (!o.equals(el[i])) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        E e = this.elems[index];
        this.fastRemove(index);
        return e;
    }

    @Override
    public final void clear() {
        ++this.modCount;
        for (int index = 0; index < this.size; ++index) {
            this.elems[index] = null;
        }
        this.size = 0;
    }

    @Override
    public final int indexOf(Object o) {
        Objects.requireNonNull(o);
        E[] el = this.elems;
        int si = this.size;
        for (int i = 0; i < si; ++i) {
            if (!el[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Objects.requireNonNull(o);
        E[] el = this.elems;
        int si = this.size;
        for (int i = si - 1; i >= 0; --i) {
            if (!el[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    private void ensureCapacityInternal(int min) {
        int minCapacity = min;
        if (this.elems == EMPTY_ELEMENTDATA) {
            minCapacity = Math.max(8, minCapacity);
        }
        ++this.modCount;
        if (minCapacity - this.elems.length > 0) {
            this.grow(minCapacity);
        }
    }

    protected final void grow(int minCapacity) {
        int oldCapacity = this.elems.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x3FFFFFFF > 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = minCapacity > 0x3FFFFFFF ? Integer.MAX_VALUE : 0x3FFFFFFF;
        }
        this.elems = (Externalizable[])Arrays.copyOf(this.elems, newCapacity);
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elems, index + 1, this.elems, index, numMoved);
        }
        this.elems[--this.size] = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(System.identityHashCode(this));
        builder.append(" [");
        for (int i = 0; i < this.size; ++i) {
            builder.append(this.elems[i]).append(",");
        }
        builder.insert(builder.length() - 1, ']');
        return builder.toString();
    }

    protected final void addUncheck(E item) {
        this.elems[this.size++] = item;
    }

    protected final E[] getElems() {
        return this.elems;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        E[] iterable = this.elems;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (!iterable[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        E[] iterable = this.elems;
        final int max = this.size;
        return new Iterator<E>((Externalizable[])iterable){
            int i = 0;
            final /* synthetic */ Externalizable[] val$iterable;
            {
                this.val$iterable = externalizableArray;
            }

            @Override
            public boolean hasNext() {
                return this.i < max;
            }

            @Override
            public E next() {
                if (this.i >= max) {
                    throw new NoSuchElementException();
                }
                return this.val$iterable[this.i++];
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("listIterator()");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator(int index)");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList(int fromIndex, int toIndex)");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("toArray()");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("toArray(" + a + ")");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll()");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll()");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll()");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll()");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll()");
    }
}

