/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.akn.util;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AknReadException;
import io.legaldocml.akn.AkomaNtoso;
import io.legaldocml.akn.DocumentType;
import io.legaldocml.akn.HasMixedContent;
import io.legaldocml.akn.MandatoryElementException;
import io.legaldocml.akn.element.StringInlineCM;
import io.legaldocml.akn.other.UnsupportedModule;
import io.legaldocml.akn.util.AknList;
import io.legaldocml.io.QName;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.impl.XmlChannelReader;
import io.legaldocml.module.AknModule;
import io.legaldocml.module.Module;
import io.legaldocml.module.Modules;
import io.legaldocml.util.CharArray;
import io.legaldocml.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlReaderHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlChannelReader.class);

    private XmlReaderHelper() {
    }

    public static <T extends DocumentType> AkomaNtoso<T> createAkomaNtoso(XmlReader reader) {
        if (!"akomaNtoso".equals(reader.getQName().getLocalName())) {
            throw new MandatoryElementException(null, "akomaNtoso", reader);
        }
        NamespaceConsumer namespaceConsumer = new NamespaceConsumer();
        reader.getNamespaces().forEach(namespaceConsumer);
        AknModule aknModule = namespaceConsumer.getAknModules();
        if (aknModule == null) {
            throw new AknReadException(AknReadException.Type.AKN_MODULE_NOT_FOUND, reader, new Object[0]);
        }
        AkomaNtoso akomaNtoso = new AkomaNtoso(aknModule.newAkomaNtosoContext());
        reader.setContext(akomaNtoso.getContext());
        for (Module module : namespaceConsumer.getModules()) {
            if (module == aknModule) continue;
            akomaNtoso.getContext().add(module);
        }
        reader.nextStartOrEndElement();
        return akomaNtoso;
    }

    public static <T extends AknObject> void read(XmlReader reader, AknList<T> list, ImmutableMap<String, Supplier<T>> map) {
        QName qName = reader.getQName();
        do {
            if (reader.getEventType() == 8) {
                return;
            }
            int eventType = reader.next();
            if (eventType != 1) continue;
            XmlReaderHelper.onStartElement(reader, list, map, qName);
        } while (reader.getEventType() != 2 || !qName.equals(reader.getQName()));
    }

    public static <T extends AknObject> void read(XmlReader reader, AknList<T> list, ImmutableMap<String, Supplier<T>> map, QName parent) {
        while (true) {
            if (reader.getEventType() == 1) {
                XmlReaderHelper.onStartElement(reader, list, map, parent);
                reader.nextStartOrEndElement();
                continue;
            }
            if (reader.getEventType() == 2 && parent.equals(reader.getQName())) break;
            if (reader.getEventType() == 8) {
                return;
            }
            if (reader.getEventType() == 1) continue;
            reader.next();
        }
    }

    public static <T extends HasMixedContent> void readWithCharacters(XmlReader reader, AknList<T> list, ImmutableMap<String, Supplier<T>> map) {
        QName qName = reader.getQName();
        while (true) {
            if (reader.getEventType() == 8) {
                return;
            }
            int eventType = reader.next();
            if (eventType == 1) {
                XmlReaderHelper.onStartElement(reader, list, map, qName);
            }
            if (reader.getEventType() == 4) {
                char[] content = reader.getText().value();
                if (content == null) continue;
                list.add((T)new StringInlineCM(content));
                continue;
            }
            if (reader.getEventType() == 2 && qName.equals(reader.getQName())) break;
        }
    }

    public static <T extends AknObject> void read(XmlReader reader, AknList<T> list, ImmutableMap<String, Supplier<T>> map, QName parent, String otherLocalName) {
        int depth = reader.getDepth() - 1;
        while (true) {
            if (reader.getEventType() == 1) {
                if (reader.getQName().equalsLocalName(otherLocalName)) {
                    return;
                }
                XmlReaderHelper.onStartElement(reader, list, map, parent);
            }
            if (reader.getEventType() == 8) {
                return;
            }
            if (reader.getEventType() == 2 && depth == reader.getDepth() && parent.equals(reader.getQName())) {
                return;
            }
            if (reader.getEventType() == 8) {
                return;
            }
            if (reader.getEventType() == 1) continue;
            reader.next();
        }
    }

    private static <T extends AknObject> void onStartElement(XmlReader reader, AknList<T> list, ImmutableMap<String, Supplier<T>> map, QName parent) {
        Supplier supplier = (Supplier)map.get((Object)reader.getQName().getLocalName());
        if (supplier == null) {
            throw new AknReadException(AknReadException.Type.MISSING_ELEMENT, reader, parent);
        }
        AknObject ako = (AknObject)supplier.get();
        ako.read(reader);
        list.add((T)ako);
    }

    private static final class NamespaceConsumer
    implements BiConsumer<CharArray, CharArray> {
        private final List<Module> modules = new ArrayList<Module>(4);

        private NamespaceConsumer() {
        }

        @Override
        public void accept(CharArray prefix, CharArray ns) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("namespace : prefix [{}] -> value [{}]", (Object)prefix, (Object)ns);
            }
            if (Strings.isEmpty(prefix) && Strings.isEmpty(ns)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("default namespace xmlns empty -> skip");
                }
                return;
            }
            Module mod = Modules.get(ns);
            if (mod == null) {
                LOGGER.info("Unsupported module for prefix [{}] and uri [{}]", (Object)prefix, (Object)ns);
                mod = new UnsupportedModule(prefix, ns);
            }
            this.modules.add(mod);
        }

        List<Module> getModules() {
            return this.modules;
        }

        AknModule getAknModules() {
            AknModule aknModule = null;
            for (Module module : this.modules) {
                if (!(module instanceof AknModule)) continue;
                if (aknModule != null) {
                    throw new RuntimeException();
                }
                aknModule = (AknModule)module;
            }
            return aknModule;
        }
    }
}

