/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.business.AknIdentifier;
import io.legaldocml.business.BusinessException;
import io.legaldocml.business.builder.BusinessBuilder;
import io.legaldocml.business.builder.BusinessPartBuilder;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BusinessProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessProvider.class);
    private static final ImmutableMap<String, BusinessProvider> PROVIDERS;

    public abstract String name();

    public static BusinessProvider businessProvider(String provider) {
        BusinessProvider businessProvider;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Business Provider [{}]", (Object)provider);
        }
        if ((businessProvider = (BusinessProvider)PROVIDERS.get((Object)provider)) == null) {
            throw new BusinessException("Provider [" + provider + "] not found");
        }
        return businessProvider;
    }

    public abstract AknIdentifier newAknIdentifier(String var1, String var2, String var3);

    public abstract AknIdentifier extractAknIdentifier(String var1, String var2, String var3);

    public abstract AknIdentifier newAknIdentifierTransient();

    public abstract <E extends BusinessBuilder> E newBuilder(String var1);

    public abstract <E extends BusinessPartBuilder> E newPartBuilder(BusinessBuilder var1, AknObject var2, String var3);

    static {
        ServiceLoader<BusinessProvider> serviceLoader = ServiceLoader.load(BusinessProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<BusinessProvider> iterator = serviceLoader.iterator();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while (iterator.hasNext()) {
            BusinessProvider provider = iterator.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("BusinessProvider [{}] -> [{}]", (Object)provider.name(), (Object)provider);
            }
            builder.put((Object)provider.name(), (Object)provider);
        }
        PROVIDERS = builder.build();
    }
}

