/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class MediaType {
    public static final MediaType LEGALDOCML = new MediaType("application", "akn+xml");
    private final String type;
    private final String subType;
    private static final Map<String, MediaType> ALL = ImmutableMap.builder().put((Object)LEGALDOCML.toString(), (Object)LEGALDOCML).build();

    private MediaType(String type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type).append('/').append(this.subType);
        return builder.toString();
    }

    public static MediaType valueOf(String value) {
        MediaType mediaType = ALL.get(value);
        if (mediaType != null) {
            return mediaType;
        }
        String[] values = value.split("/");
        if (values.length != 2) {
            throw new RuntimeException("");
        }
        return new MediaType(values[0], values[1]);
    }
}

