/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business.builder;

import com.google.common.collect.ImmutableList;
import io.legaldocml.akn.element.Hierarchy;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HierarchyStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchyStrategy.class);
    private final ImmutableList<Class<? extends Hierarchy>> keys;
    private final ImmutableList<Supplier<? extends Hierarchy>> values;

    HierarchyStrategy(ImmutableList<Class<? extends Hierarchy>> keys, ImmutableList<Supplier<? extends Hierarchy>> values) {
        this.keys = keys;
        this.values = values;
    }

    public <E> E next(Hierarchy hierarchy) {
        int index = this.keys.indexOf(hierarchy.getClass());
        if (index == -1) {
            return null;
        }
        if (index + 1 > this.keys.size()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[{}] -> [{}]", (Object)hierarchy.getClass().getSimpleName(), (Object)((Class)this.keys.get(index + 1)).getSimpleName());
        }
        return (E)((Supplier)this.values.get(index + 1)).get();
    }
}

