/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business.builder.element;

import io.legaldocml.akn.attribute.Id;
import io.legaldocml.akn.element.BaseHierarchy;
import io.legaldocml.akn.element.Content;
import io.legaldocml.akn.element.Heading;
import io.legaldocml.akn.element.Hierarchy;
import io.legaldocml.akn.element.HierarchyElement;
import io.legaldocml.akn.element.Intro;
import io.legaldocml.akn.element.Num;
import io.legaldocml.akn.element.Subheading;
import io.legaldocml.business.builder.AbstractBusinessPartBuilder;
import io.legaldocml.business.builder.BusinessBuilder;
import io.legaldocml.business.builder.BusinessBuilderException;
import io.legaldocml.business.builder.element.BlocksBuilder;
import io.legaldocml.business.builder.element.InlineReqTypeBuilder;
import io.legaldocml.business.builder.element.InlineTypeBuilder;
import io.legaldocml.business.builder.group.HierElementsBuilder;
import io.legaldocml.business.util.EidFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class HierarchyBuilder<T extends Hierarchy>
extends AbstractBusinessPartBuilder<T>
implements HierElementsBuilder<T> {
    private final Hierarchy parent;
    private final T hierarchy;

    public HierarchyBuilder(BusinessBuilder businessBuilder, T hierarchy) {
        this(businessBuilder, null, hierarchy);
    }

    public HierarchyBuilder(BusinessBuilder businessBuilder, Hierarchy parent, T hierarchy) {
        super(businessBuilder, hierarchy);
        this.parent = parent;
        this.hierarchy = hierarchy;
    }

    public final InlineTypeBuilder<Num> num() {
        if (((BaseHierarchy)this.hierarchy).getNum() != null) {
            throw new BusinessBuilderException("<num> is not null : [" + ((BaseHierarchy)this.hierarchy).getNum() + "]");
        }
        Num num = new Num();
        ((BaseHierarchy)this.hierarchy).setNum(num);
        return new InlineTypeBuilder<Num>(this.getBusinessBuilder(), num);
    }

    public InlineReqTypeBuilder<Heading> heading() {
        return this.heading(null);
    }

    public InlineReqTypeBuilder<Heading> heading(Consumer<Heading> consumer) {
        if (((BaseHierarchy)this.hierarchy).getHeading() != null) {
            throw new BusinessBuilderException("<heading> is not null : [" + ((BaseHierarchy)this.hierarchy).getHeading() + "]");
        }
        Heading heading = new Heading();
        ((BaseHierarchy)this.hierarchy).setHeading(heading);
        if (consumer != null) {
            consumer.accept(heading);
        }
        return new InlineReqTypeBuilder<Heading>(this.getBusinessBuilder(), heading);
    }

    public InlineReqTypeBuilder<Subheading> subHeading() {
        if (((BaseHierarchy)this.hierarchy).getSubheading() != null) {
            throw new BusinessBuilderException("<subheading> is not null : [" + ((BaseHierarchy)this.hierarchy).getSubheading() + "]");
        }
        Subheading subheading = new Subheading();
        ((BaseHierarchy)this.hierarchy).setSubheading(subheading);
        return new InlineReqTypeBuilder<Subheading>(this.getBusinessBuilder(), subheading);
    }

    public HierarchyBuilder<T> eId(String number) {
        EidFactory.makeAndFill(this.parent, this.hierarchy, number);
        return this;
    }

    public <E extends Hierarchy> HierarchyBuilder<E> next() {
        Hierarchy el = (Hierarchy)this.getBusinessBuilder().getStrategy().next((Hierarchy)this.hierarchy);
        ((Hierarchy)this.hierarchy).addHierarchyElement((HierarchyElement)((Object)el));
        return new HierarchyBuilder<Hierarchy>(this.getBusinessBuilder(), (Hierarchy)this.hierarchy, el);
    }

    public <E extends Hierarchy> HierarchyBuilder<E> newChild(String element) {
        HierarchyElement el = (HierarchyElement)((Supplier)Hierarchy.ELEMS.get((Object)element)).get();
        ((Hierarchy)this.hierarchy).addHierarchyElement(el);
        return new HierarchyBuilder<Hierarchy>(this.getBusinessBuilder(), (Hierarchy)((Object)el));
    }

    public BlocksBuilder<Intro> intro() {
        return this.intro(null);
    }

    public BlocksBuilder<Intro> intro(Consumer<Intro> consumer) {
        if (((Hierarchy)this.hierarchy).getIntro() != null) {
            throw new BusinessBuilderException("<intro> is not null : [" + ((Hierarchy)this.hierarchy).getIntro() + "]");
        }
        Intro intro = new Intro();
        ((Hierarchy)this.hierarchy).setIntro(intro);
        if (consumer != null) {
            consumer.accept(intro);
        }
        return new BlocksBuilder<Intro>(this.getBusinessBuilder(), (Id)this.hierarchy, intro);
    }

    public BlocksBuilder<Content> content() {
        return this.content(null);
    }

    public BlocksBuilder<Content> content(Consumer<Content> consumer) {
        if (((Hierarchy)this.hierarchy).getContent() != null) {
            throw new BusinessBuilderException("<content> is not null : [" + ((Hierarchy)this.hierarchy).getContent() + "]");
        }
        Content content = new Content();
        ((Hierarchy)this.hierarchy).setContent(content);
        if (consumer != null) {
            consumer.accept(content);
        }
        return new BlocksBuilder<Content>(this.getBusinessBuilder(), (Id)this.hierarchy, content);
    }
}

