/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business.impl;

import io.legaldocml.business.AknIdentifier;
import io.legaldocml.util.ToStringBuilder;
import java.util.Objects;

final class DefaultAknIdentifier
extends AknIdentifier {
    private final String workPart;
    private final String expressionPart;
    private final String manifestationPart;
    private final String separator;

    public DefaultAknIdentifier(String workPart, String expressionPart, String manifestationPart, String separator) {
        this.workPart = workPart;
        this.expressionPart = expressionPart;
        this.manifestationPart = manifestationPart;
        this.separator = separator;
    }

    @Override
    public String work() {
        return this.workPart;
    }

    @Override
    public String expression() {
        return this.workPart + this.separator + this.expressionPart;
    }

    @Override
    public String expressionPart() {
        return this.expressionPart;
    }

    @Override
    public String manifestation() {
        return this.workPart + this.separator + this.expressionPart + this.separator + this.manifestationPart;
    }

    @Override
    public String manifestationPart() {
        return this.manifestationPart;
    }

    @Override
    protected boolean doEquals(AknIdentifier aknIdentifier) {
        return Objects.equals(this.workPart, aknIdentifier.work()) && Objects.equals(this.expressionPart, aknIdentifier.expressionPart()) && Objects.equals(this.manifestationPart, aknIdentifier.manifestationPart());
    }

    public String toString() {
        return new ToStringBuilder(this).append("work", this.workPart).append("expression", this.expressionPart).append("manifestation", this.manifestationPart).toString();
    }
}

