/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business.util;

import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.AkomaNtoso;
import io.legaldocml.akn.DocumentType;
import io.legaldocml.akn.attribute.Link;
import io.legaldocml.akn.attribute.Refers;
import io.legaldocml.akn.attribute.Role;
import io.legaldocml.akn.element.RefItem;
import io.legaldocml.akn.element.ReferenceType;
import io.legaldocml.akn.element.References;
import io.legaldocml.akn.element.TLCRole;
import io.legaldocml.akn.group.TLC;
import io.legaldocml.akn.type.AgentRef;
import io.legaldocml.akn.type.ListReferenceRef;
import io.legaldocml.akn.type.Uri;
import io.legaldocml.business.util.AknReferenceException;
import io.legaldocml.unsafe.UnsafeString;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AknReference
implements BiConsumer<AknObject, AkomaNtoso<? extends DocumentType>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AknReference.class);

    protected AknReference() {
    }

    public static <T extends ReferenceType> AknReference refersTo(final AgentRef source, final T refersTo) {
        return new AknReference(){

            @Override
            public void accept(AknObject object, AkomaNtoso<? extends DocumentType> akn) {
                Optional<RefItem> op;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("reference with source[{}] from [{}] refersTo [{}]", new Object[]{source, object, refersTo});
                }
                if (!(object instanceof Refers)) {
                    throw new AknReferenceException("Not a instance of Refers [" + object + "]");
                }
                ((Refers)object).setRefersTo(new ListReferenceRef(UnsafeString.getChars("#" + refersTo.getEid().toString())));
                References ref = akn.getDocumentType().getMeta().getReferences(source);
                if (ref == null) {
                    ref = new References();
                    ref.setSource(source);
                    akn.getDocumentType().getMeta().add(ref);
                }
                if (!(op = ref.getRefItems().stream().filter(t -> t.equals(refersTo)).findFirst()).isPresent()) {
                    ref.add((RefItem)((Object)refersTo));
                }
            }
        };
    }

    public static AknReference as(final AgentRef source, final TLCRole role) {
        return new AknReference(){

            @Override
            public void accept(AknObject object, AkomaNtoso<? extends DocumentType> akn) {
                Optional<RefItem> op;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("reference with source[{}] from [{}] as [{}]", new Object[]{source, object, role});
                }
                if (!(object instanceof Role)) {
                    throw new AknReferenceException("Not a instance of Role [" + object + "]");
                }
                ((Role)object).setAs(role.getEid().toRoleRef());
                References ref = akn.getDocumentType().getMeta().getReferences(source);
                if (ref == null) {
                    ref = new References();
                    ref.setSource(source);
                    akn.getDocumentType().getMeta().add(ref);
                }
                if (!(op = ref.getRefItems().stream().filter(t -> t.equals(role)).findFirst()).isPresent()) {
                    ref.add(role);
                }
            }
        };
    }

    public static AknReference href(final AgentRef source, final TLC tlc) {
        return new AknReference(){

            @Override
            public void accept(AknObject object, AkomaNtoso<? extends DocumentType> akn) {
                Optional<RefItem> op;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("reference with source [{}] from [{}] as [{}]", new Object[]{source, object, tlc});
                }
                if (!(object instanceof Link)) {
                    throw new AknReferenceException("Not a instance of Role [" + object + "]");
                }
                ((Link)object).setHref(Uri.valueOf(tlc.getEid().makeRef()));
                References ref = akn.getDocumentType().getMeta().getReferences(source);
                if (ref == null) {
                    ref = new References();
                    ref.setSource(source);
                    akn.getDocumentType().getMeta().add(ref);
                }
                if (!(op = ref.getRefItems().stream().filter(t -> t.equals(tlc)).findFirst()).isPresent()) {
                    ref.add(tlc);
                }
            }
        };
    }
}

