/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.business.util;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.akn.AknObject;
import io.legaldocml.akn.attribute.Id;
import io.legaldocml.akn.element.Alinea;
import io.legaldocml.akn.element.AmendmentBody;
import io.legaldocml.akn.element.Article;
import io.legaldocml.akn.element.Attachment;
import io.legaldocml.akn.element.BlockList;
import io.legaldocml.akn.element.Body;
import io.legaldocml.akn.element.Chapter;
import io.legaldocml.akn.element.Citation;
import io.legaldocml.akn.element.Citations;
import io.legaldocml.akn.element.Clause;
import io.legaldocml.akn.element.Component;
import io.legaldocml.akn.element.ComponentRef;
import io.legaldocml.akn.element.Components;
import io.legaldocml.akn.element.DebateBody;
import io.legaldocml.akn.element.DebateSection;
import io.legaldocml.akn.element.Division;
import io.legaldocml.akn.element.DocumentRef;
import io.legaldocml.akn.element.EventRef;
import io.legaldocml.akn.element.Intro;
import io.legaldocml.akn.element.JudgmentBody;
import io.legaldocml.akn.element.List;
import io.legaldocml.akn.element.ListIntroduction;
import io.legaldocml.akn.element.ListWrapUp;
import io.legaldocml.akn.element.MainBody;
import io.legaldocml.akn.element.Paragraph;
import io.legaldocml.akn.element.QuotedStructure;
import io.legaldocml.akn.element.QuotedText;
import io.legaldocml.akn.element.Recital;
import io.legaldocml.akn.element.Recitals;
import io.legaldocml.akn.element.Section;
import io.legaldocml.akn.element.Subchapter;
import io.legaldocml.akn.element.Subclause;
import io.legaldocml.akn.element.Subdivision;
import io.legaldocml.akn.element.Subparagraph;
import io.legaldocml.akn.element.Subsection;
import io.legaldocml.akn.element.TemporalGroup;
import io.legaldocml.akn.element.WrapUp;
import io.legaldocml.akn.type.NoWhiteSpace;
import io.legaldocml.unsafe.UnsafeString;
import io.legaldocml.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EidFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EidFactory.class);
    private static final ImmutableMap<Class<? extends AknObject>, String> ELEMENTS_REFS = ImmutableMap.builder().put(Body.class, (Object)"body").put(Alinea.class, (Object)"al").put(AmendmentBody.class, (Object)"body").put(Article.class, (Object)"art").put(Attachment.class, (Object)"att").put(BlockList.class, (Object)"list").put(Chapter.class, (Object)"chp").put(Citation.class, (Object)"cit").put(Citations.class, (Object)"cits").put(Clause.class, (Object)"cl").put(Component.class, (Object)"cmp").put(Components.class, (Object)"cmpnts").put(ComponentRef.class, (Object)"cref").put(DebateBody.class, (Object)"body").put(DebateSection.class, (Object)"dbsect").put(Division.class, (Object)"dvs").put(DocumentRef.class, (Object)"dref").put(EventRef.class, (Object)"eref").put(JudgmentBody.class, (Object)"body").put(Intro.class, (Object)"intro").put(List.class, (Object)"list").put(ListIntroduction.class, (Object)"intro").put(ListWrapUp.class, (Object)"wrap").put(MainBody.class, (Object)"body").put(Paragraph.class, (Object)"para").put(QuotedStructure.class, (Object)"qstr").put(QuotedText.class, (Object)"qtext").put(Recital.class, (Object)"rec").put(Recitals.class, (Object)"recs").put(Section.class, (Object)"sec").put(Subchapter.class, (Object)"subchp").put(Subclause.class, (Object)"subcl").put(Subdivision.class, (Object)"subdvs").put(Subparagraph.class, (Object)"subpara").put(Subsection.class, (Object)"subsec").put(TemporalGroup.class, (Object)"tmpg").put(WrapUp.class, (Object)"wrapup").build();
    private static final char[] PREFIX_SEPARATOR = new char[]{'_', '_'};
    private static final char REF_SEPARATOR = '_';
    private final StringBuilder builder = new StringBuilder();

    public static <T extends AknObject> String getElementRef(Class<T> clazz) {
        return (String)ELEMENTS_REFS.get(clazz);
    }

    public static void makeAndFill(Id object) {
        NoWhiteSpace space = EidFactory.make(null, object, null);
        object.setEid(space);
    }

    public static void makeAndFill(Id object, String number) {
        NoWhiteSpace space = EidFactory.make(object, number);
        object.setEid(space);
    }

    public static void makeAndFill(Id parent, Id object) {
        NoWhiteSpace space = EidFactory.make(parent, object, null);
        object.setEid(space);
    }

    public static void makeAndFill(Id parent, Id object, String number) {
        NoWhiteSpace space = EidFactory.make(parent, object, number);
        object.setEid(space);
    }

    public static NoWhiteSpace make(Id object, String number) {
        return EidFactory.make(null, object, number);
    }

    public static NoWhiteSpace make(Id parent, Id object) {
        return EidFactory.make(parent, object, null);
    }

    public static NoWhiteSpace make(Id parent, Id object, String number) {
        String ref;
        if (object.getEid() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Object [{}] has already an eId", (Object)object);
            }
            return object.getEid();
        }
        EidFactory builder = new EidFactory();
        if (parent != null && parent.getEid() != null) {
            builder.append(parent.getEid());
            builder.appendPrefixSeparator();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parent eid : [{}]", (Object)parent.getEid());
            }
        }
        if ((ref = (String)ELEMENTS_REFS.get(object.getClass())) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Class [{}] not defined -> use name [{}]", (Object)object.getClass().getSimpleName(), (Object)object.name());
            }
            ref = object.name();
        }
        builder.append(ref);
        if (!Strings.isEmpty(number)) {
            builder.appendSeparator();
            builder.append(number);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Make eId [{}]", (Object)builder);
        }
        return builder.build();
    }

    private NoWhiteSpace build() {
        return NoWhiteSpace.valueOf(UnsafeString.getChars(this.builder.toString()));
    }

    private EidFactory() {
    }

    private void appendPrefixSeparator() {
        this.builder.append(PREFIX_SEPARATOR);
    }

    private void append(NoWhiteSpace eid) {
        this.builder.append(eid.getChars());
    }

    private void append(String ref) {
        this.builder.append(ref);
    }

    private void appendSeparator() {
        this.builder.append('_');
    }

    public String toString() {
        return this.builder.toString();
    }
}

