/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.diff.impl;

import io.legaldocml.akn.AknObject;
import io.legaldocml.diff.Diff;
import io.legaldocml.diff.DiffContext;
import io.legaldocml.diff.DiffResult;
import io.legaldocml.diff.DiffType;
import io.legaldocml.diff.impl.AttributeValueDiff;
import io.legaldocml.diff.impl.DiffResultImpl;
import io.legaldocml.diff.impl.InsertElementDiff;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DiffContextImpl
implements DiffContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiffContext.class);
    private final LinkedList<AknObject> akns = new LinkedList();
    private final List<Diff> diffs = new ArrayList<Diff>();

    DiffContextImpl() {
    }

    @Override
    public <T extends AknObject> void push(T aknObject) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("push({}) -> [{}]", (Object)aknObject.name(), (Object)this.path());
        }
        this.akns.add(aknObject);
    }

    @Override
    public <T extends AknObject> void missingElement(T aknObject) {
    }

    public <T extends AknObject> void mismatchElement(T aknObject) {
    }

    @Override
    public <T extends AknObject> void pop(T aknObject) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("pop({}) -> [{}]", (Object)aknObject.name(), (Object)this.path());
        }
        this.akns.removeLast();
    }

    private String path() {
        StringBuilder builder = new StringBuilder(128);
        for (AknObject akn : this.akns) {
            builder.append('/').append(akn.name());
        }
        return builder.toString();
    }

    @Override
    public <T extends AknObject> void mismatchElement(T left, T right) {
    }

    @Override
    public <T extends AknObject> void insertElement(T right) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("element [{}] : inserted [{}]", (Object)right.name(), right);
        }
        this.diffs.add(new InsertElementDiff(this.getPath(), null, right));
    }

    @Override
    public <T extends AknObject> void attributeNew(String name, Object valueRight, T left, T right) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("attribute [{}] : New with value [{}] - [{}]", (Object)name, valueRight);
        }
        this.diffs.add(new AttributeValueDiff(DiffType.ATTRIBUTE_INSERTED, this.getPath(), name, null, valueRight, left, right));
    }

    @Override
    public <T extends AknObject> void attributeRemove(String name, Object valueLeft, T left, T right) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("attribute [{}] is removed, old value [{}]", (Object)name, valueLeft);
        }
        this.diffs.add(new AttributeValueDiff(DiffType.ATTRIBUTE_REMOVED, this.getPath(), name, valueLeft, null, left, right));
    }

    public void attributeValueDifferent(String name, Object valueLeft, Object valueRight, AknObject left, AknObject right) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("attribute [{}] has different value [{}] - [{}]", new Object[]{name, valueLeft, valueRight});
        }
        this.diffs.add(new AttributeValueDiff(DiffType.ATTRIBUTE_VALUE, this.getPath(), name, valueLeft, valueRight, left, right));
    }

    public DiffResult result() {
        return new DiffResultImpl(this.diffs);
    }

    private String getPath() {
        StringBuilder builder = new StringBuilder();
        for (AknObject akn : this.akns) {
            builder.append('/').append(akn.name());
        }
        return builder.toString();
    }
}

