/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io;

import io.legaldocml.io.XmlReaderFactory;
import io.legaldocml.io.XmlWriterFactory;
import io.legaldocml.io.XmlWriterFactoryProvider;
import io.legaldocml.io.impl.DefaultXmlProvider;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXmlProvider.class);
    private static final XmlProvider XML_PROVIDER;

    protected abstract XmlWriterFactory getWriterFactory();

    protected abstract XmlReaderFactory getReaderFactory();

    public static XmlWriterFactory writerFactory(int version) {
        return XML_PROVIDER.getWriterFactory();
    }

    public static XmlReaderFactory readerFactory() {
        return XML_PROVIDER.getReaderFactory();
    }

    static {
        XmlWriterFactoryProvider.checkInit();
        ServiceLoader<XmlProvider> serviceLoader = ServiceLoader.load(XmlProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<XmlProvider> iterator = serviceLoader.iterator();
        XmlProvider provider = null;
        while (iterator.hasNext()) {
            provider = iterator.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("found XmlProvider impl -> [{}]", provider.getClass());
            }
            if (provider instanceof DefaultXmlProvider) continue;
        }
        XML_PROVIDER = provider;
        LOGGER.info("XmlProvider : [{}]", (Object)provider);
    }
}

