/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io;

import io.legaldocml.io.XmlReaderFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlReaderFactoryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlReaderFactoryProvider.class);
    private static final XmlReaderFactoryProvider FACTORY_SERVICE_LOADER;

    public static XmlReaderFactory newXmlReaderFactory(int size) {
        return FACTORY_SERVICE_LOADER.createXmlReaderFactory(size);
    }

    protected abstract XmlReaderFactory createXmlReaderFactory(int var1);

    static {
        ServiceLoader<XmlReaderFactoryProvider> serviceLoader = ServiceLoader.load(XmlReaderFactoryProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<XmlReaderFactoryProvider> iterator = serviceLoader.iterator();
        FACTORY_SERVICE_LOADER = iterator.next();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("XmlReaderFactoryProvider impl -> [{}]", (Object)FACTORY_SERVICE_LOADER);
        }
    }
}

