/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io;

import io.legaldocml.io.XmlWriterFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlWriterFactoryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlWriterFactoryProvider.class);
    private static final XmlWriterFactoryProvider INSTANCE;

    public static XmlWriterFactory xmlWriterFactory(int size) {
        return INSTANCE.createXmlWriterFactory(size);
    }

    protected abstract XmlWriterFactory createXmlWriterFactory(int var1);

    public static void checkInit() {
    }

    static {
        ServiceLoader<XmlWriterFactoryProvider> serviceLoader = ServiceLoader.load(XmlWriterFactoryProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<XmlWriterFactoryProvider> iterator = serviceLoader.iterator();
        INSTANCE = iterator.next();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("XmlWriterFactoryProvider implementation -> [{}]", INSTANCE.getClass());
        }
    }
}

