/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.DirectBuffer;

public final class Buffers {
    private static final Map<String, ByteBuffer> REF = new HashMap<String, ByteBuffer>();

    private Buffers() {
    }

    public static long address(String element) {
        ByteBuffer buffer = REF.get(element);
        if (buffer == null) {
            byte[] bytes = element.getBytes(StandardCharsets.US_ASCII);
            buffer = ByteBuffer.allocateDirect(bytes.length);
            buffer.put(bytes);
            buffer.flip();
            REF.put(element, buffer);
        }
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static long address(MappedByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static void releaseDirectByteBuffer(MappedByteBuffer buffer) {
        ((DirectBuffer)((Object)buffer)).cleaner().clean();
    }

    public static MappedByteBuffer direct(byte[] bytes) {
        MappedByteBuffer buffer = (MappedByteBuffer)ByteBuffer.allocateDirect(bytes.length);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }
}

