/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.LegalDocMlException;
import io.legaldocml.io.Externalizable;
import io.legaldocml.io.XmlWriterFactory;
import io.legaldocml.io.impl.XmlChannelWriter;
import io.legaldocml.pool.Pool;
import io.legaldocml.pool.PoolHolder;
import io.legaldocml.pool.PoolableObject;
import io.legaldocml.pool.Pools;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public abstract class DefaultXmlWriterFactory
implements XmlWriterFactory {
    public static final int DEFAULT_POOL_SIZE = 16;
    private final Pool<PoolHolder<XmlChannelWriter>> pool;

    public DefaultXmlWriterFactory(XmlChannelWriterPoolObject poolObject) {
        this(16, poolObject);
    }

    public DefaultXmlWriterFactory(int size, XmlChannelWriterPoolObject poolObject) {
        this.pool = Pools.createPool(size, poolObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(WritableByteChannel wbc, Externalizable externalizable) throws IOException {
        PoolHolder<XmlChannelWriter> holder = this.pool.checkOut();
        try {
            XmlChannelWriter writer = (XmlChannelWriter)holder.get();
            writer.setChannel(wbc);
            externalizable.write(writer);
            writer.flush();
        }
        finally {
            this.pool.checkIn(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LegalDocMlException> writePermissive(WritableByteChannel wbc, Externalizable externalizable) throws IOException {
        List<LegalDocMlException> exceptions;
        PoolHolder<XmlChannelWriter> holder = this.pool.checkOut();
        try {
            XmlChannelWriter writer = (XmlChannelWriter)holder.get();
            writer.setPermissive(true);
            writer.setChannel(wbc);
            externalizable.write(writer);
            writer.flush();
            exceptions = writer.getExceptions();
        }
        finally {
            this.pool.checkIn(holder);
        }
        return exceptions;
    }

    protected static abstract class XmlChannelWriterPoolObject
    implements PoolableObject<XmlChannelWriter> {
        protected XmlChannelWriterPoolObject() {
        }

        @Override
        public final void passivate(XmlChannelWriter xmlChannelWriter) {
            xmlChannelWriter.reset();
        }
    }
}

