/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.io.Namespaces;
import io.legaldocml.io.impl.XmlChannelReader;
import io.legaldocml.io.impl.XmlChannelReaderException;
import io.legaldocml.util.CharArray;
import io.legaldocml.util.CharArrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NamespacesImpl
implements Namespaces {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespacesImpl.class);
    private static final int MAX = 16;
    private static final CharArray PREFIX_XML = CharArrays.immutable("xml");
    private static final CharArray URI_XML = CharArrays.immutable("http://www.w3.org/XML/1998/namespace");
    private final CharArray[] uris = new CharArray[16];
    private final CharArray[] prefixes = new CharArray[16];
    private int count = 1;
    static final Consumer<NamespacesImpl> POP_ACTION = namespaces -> {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("pop namespaces : prefix=[{}] uri=[{}] ", (Object)namespaces.prefixes[namespaces.count - 1], (Object)namespaces.uris[namespaces.count - 1]);
        }
        namespaces.prefixes[namespaces.count - 1] = null;
        namespaces.uris[namespaces.count - 1] = null;
        --namespaces.count;
    };

    NamespacesImpl() {
    }

    @Override
    public CharArray get(CharArray prefix) {
        if (PREFIX_XML.equals(prefix)) {
            return URI_XML;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!prefix.equals(this.prefixes(i))) continue;
            return this.uris[i];
        }
        return null;
    }

    @Override
    public CharArray getDefaultNamespaceUri() {
        return this.uris[0];
    }

    @Override
    public void forEach(BiConsumer<CharArray, CharArray> consumer) {
        int i = 0;
        if (this.prefixes[i] == null && this.uris[i] == null) {
            LOGGER.info("no default namespace");
            ++i;
        }
        while (i < this.count) {
            consumer.accept(this.prefixes[i], this.uris[i]);
            ++i;
        }
    }

    @Override
    public int count() {
        return this.count;
    }

    public void reset() {
        this.count = 1;
        for (int i = 0; i < 16; ++i) {
            this.uris[i] = null;
            this.prefixes[i] = null;
        }
    }

    public void setPrefix(XmlChannelReader reader, CharArray prefix, CharArray uri) {
        if (prefix.length() == 0) {
            this.setPrefixDefault(uri);
        } else {
            int i;
            for (i = 0; i < this.count; ++i) {
                if (!prefix.equals(this.prefixes[i])) continue;
                if (uri.equals(this.uris[i])) break;
                throw new XmlChannelReaderException(XmlChannelReaderException.Type.NAMESPACE_ERROR, reader);
            }
            if (i < this.count) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Prefix [{}] with URI [{}] already defined => skip", (Object)prefix, (Object)uri);
                }
            } else {
                this.uris[this.count] = uri;
                this.prefixes[this.count++] = prefix;
            }
        }
    }

    public CharArray prefixes(int index) {
        return this.prefixes[index];
    }

    public void setPrefixDefault(CharArray uri) {
        this.uris[0] = uri;
        this.prefixes[0] = DEFAULT_NS_PREFIX;
    }
}

