/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.io.QName;
import io.legaldocml.unsafe.UnsafeString;

public final class QNameImpl
implements QName {
    private final char[] full;
    private String cache;
    private final String localname;
    private final String prefix;

    QNameImpl(char[] hb, int len, int prefixLength) {
        this.full = new char[len];
        System.arraycopy(hb, 0, this.full, 0, len);
        if (prefixLength < 1) {
            this.prefix = null;
            this.localname = UnsafeString.valueOf(this.full);
        } else {
            this.prefix = new String(this.full, 0, prefixLength);
            this.localname = new String(this.full, prefixLength + 1, this.full.length - prefixLength - 1).intern();
        }
    }

    public String toString() {
        if (this.cache == null) {
            this.cache = UnsafeString.valueOf(this.full);
        }
        return this.cache;
    }

    public boolean equals(Object obj) {
        return obj instanceof QNameImpl && this.doEquals((QNameImpl)obj);
    }

    public int hashCode() {
        if (this.cache == null) {
            this.cache = UnsafeString.valueOf(this.full);
        }
        return this.cache.hashCode();
    }

    boolean doEquals(QNameImpl qName) {
        if (qName == this) {
            return true;
        }
        if (qName == null) {
            return false;
        }
        if (this.full.length != qName.full.length) {
            return false;
        }
        for (int i = 0; i < this.full.length; ++i) {
            if (this.full[i] == qName.full[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getLocalName() {
        return this.localname;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean equalsLocalName(String element) {
        return this.localname.equals(element);
    }
}

