/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.io.AttributeConsumer;
import io.legaldocml.io.Externalizable;
import io.legaldocml.io.Namespaces;
import io.legaldocml.io.ProcessingInstruction;
import io.legaldocml.io.QName;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlReaderContext;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.io.impl.NamespacesImpl;
import io.legaldocml.io.impl.ProcessingInstructionImpl;
import io.legaldocml.io.impl.QNameImpl;
import io.legaldocml.io.impl.XmlAttributes;
import io.legaldocml.io.impl.XmlChannelReaderException;
import io.legaldocml.io.impl.XmlChannelReaderStates;
import io.legaldocml.unsafe.UnsafeHelper;
import io.legaldocml.util.CharArray;
import io.legaldocml.util.CharArrays;
import io.legaldocml.util.CharBuffer;
import io.legaldocml.util.ToStringBuilder;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamConstants;
import sun.misc.Unsafe;

public final class XmlChannelReader
implements XMLStreamConstants,
XmlChannelReaderStates,
XmlReader {
    private static final int SEQUENCE_LENGTH = 128;
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();
    private final QNameImpl[] elemStack = new QNameImpl[128];
    private final Consumer<NamespacesImpl>[] nsStack = new Consumer[128];
    private final Map<Integer, QNameImpl> elemStackCache = new HashMap<Integer, QNameImpl>(256, 0.9f);
    private final XmlAttributes attributes;
    private final NamespacesImpl namespaces = new NamespacesImpl();
    private QNameImpl qName;
    private int prefixSep;
    private CharBuffer attrQName;
    private int attrPrefixSep;
    private boolean isEmpty;
    private MappedByteBuffer buf;
    private long adr;
    private int state = 1;
    private int eventType = 7;
    private int depth;
    private final CharBuffer[] seqs = new CharBuffer[128];
    private int seqsIdx = 0;
    private CharBuffer cb;
    private long max;
    private CharArray text;
    private boolean charactersPending = false;
    private ProcessingInstruction prolog;
    private XmlReaderContext context;
    private int preserveSpace = -1;
    private final boolean clearcache;

    public XmlChannelReader() {
        this(true);
    }

    public XmlChannelReader(boolean clearCache) {
        this.clearcache = clearCache;
        this.attributes = new XmlAttributes();
        for (int i = 0; i < 128; ++i) {
            this.seqs[i] = new CharBuffer();
        }
    }

    @Override
    public QName getQName() {
        if (this.eventType != 1 && this.eventType != 2) {
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.INVALID_EVENT_TYPE_QNAME, this);
        }
        return this.qName;
    }

    @Override
    public final CharArray getText() {
        if (this.eventType != 4 && this.eventType != 5 && this.eventType != 11) {
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.INVALID_EVENT_TYPE_TEXT, this);
        }
        return this.text;
    }

    @Override
    public final ProcessingInstruction getPIData() {
        if (this.eventType != 3) {
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.INVALID_EVENT_TYPE_PI, this);
        }
        return new ProcessingInstructionImpl(this.cb);
    }

    @Override
    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void preserveSpace() {
        this.preserveSpace = this.depth;
    }

    @Override
    public <T extends XmlReaderContext> void setContext(T context) {
        this.context = context;
    }

    @Override
    public <T extends XmlReaderContext> T getContext() {
        return (T)this.context;
    }

    @Override
    public int next() {
        if (this.eventType == 1) {
            if (this.isEmpty) {
                this.isEmpty = false;
                this.eventType = 2;
                return 2;
            }
        } else if (this.eventType == 2) {
            --this.depth;
            if (this.nsStack[this.depth] != null) {
                this.nsStack[this.depth].accept(this.namespaces);
                this.nsStack[this.depth] = null;
            }
        }
        block19: while (!this.isEndOfBuffer()) {
            char c = this.nextChar();
            block0 : switch (this.state) {
                case 1: {
                    int previous = 32;
                    while (true) {
                        if (c == '<') {
                            if (this.cb.length() > 0) {
                                if (this.charactersPending) {
                                    throw new UnsupportedOperationException();
                                }
                                this.text = this.cb;
                                this.seq();
                                this.charactersPending = true;
                            }
                            this.state = 2;
                            break block0;
                        }
                        if (c <= '&') {
                            char c2 = c == '&' ? this.doReplaceEntity() : (c = c < ' ' ? this.handleEndOfLine(c) : c);
                        }
                        if (this.preserveSpace == -1) {
                            if (c >= ' ' && (c != ' ' || previous != 32)) {
                                this.cb.put(c);
                            }
                        } else {
                            this.cb.put(c);
                        }
                        previous = c;
                        c = this.nextChar();
                    }
                }
                case 5: {
                    this.cb.put(c);
                    this.cb.put(this.nextChar());
                    this.cb.put(this.nextChar());
                    while (true) {
                        if (this.cb.charAt(this.cb.pos() - 1) == '>' && this.cb.charAt(this.cb.pos() - 2) == ']' && this.cb.charAt(this.cb.pos() - 3) == ']') {
                            this.cb.setPos(this.cb.pos() - 3);
                            this.state = 1;
                            break block0;
                        }
                        this.cb.put(this.nextChar());
                    }
                }
                case 16: {
                    if (c == '>') {
                        this.state = 1;
                        this.eventType = 11;
                        return 11;
                    }
                    if (c != '[') continue block19;
                    this.state = 17;
                    break;
                }
                case 17: {
                    if (c != ']') continue block19;
                    this.state = 16;
                    break;
                }
                case 2: {
                    if (this.cb.length() != 0) continue block19;
                    if (c == '/') {
                        this.state = 14;
                        this.prefixSep = -1;
                        if (!this.charactersPending) continue block19;
                        this.charactersPending = false;
                        this.eventType = 4;
                        return 4;
                    }
                    if (c == '?') {
                        this.state = 4;
                        if (!this.charactersPending) continue block19;
                        this.charactersPending = false;
                        this.eventType = 4;
                        return 4;
                    }
                    if (c != '!') {
                        this.cb.put(c);
                        this.state = 6;
                        this.prefixSep = -1;
                        if (!this.charactersPending) continue block19;
                        this.charactersPending = false;
                        this.eventType = 4;
                        return 4;
                    }
                    char c1 = this.nextChar();
                    char c2 = this.nextChar();
                    if (c1 == '-' && c2 == '-') {
                        this.state = 3;
                        if (this.charactersPending) {
                            this.charactersPending = false;
                            this.eventType = 4;
                            return 4;
                        }
                    }
                    if (c1 != '[' || c2 != 'C' || this.nextChar() != 'D' || this.nextChar() != 'A' || this.nextChar() != 'T' || this.nextChar() != 'A' || this.nextChar() != '[') continue block19;
                    this.state = 5;
                    break;
                }
                case 3: {
                    while (true) {
                        if (c == '>' && this.cb.length() > 2 && this.cb.getBefore(1) == '-' && this.cb.getBefore(2) == '-') {
                            this.text = this.cb;
                            this.seq();
                            this.eventType = 5;
                            this.state = 1;
                            return 5;
                        }
                        this.cb.put(c);
                        c = this.nextChar();
                    }
                }
                case 4: {
                    this.cb.put(c);
                    if (c != '>' || this.cb.pos() < 2 || this.cb.charAt(this.cb.pos() - 2) != '?') continue block19;
                    this.state = 1;
                    this.eventType = 3;
                    return 3;
                }
                case 6: {
                    this.attributes.reset();
                    while (true) {
                        if (c < '@') {
                            if (c == '>') {
                                this.elemStack[this.depth++] = this.qname(this.cb);
                                this.seq();
                                this.state = 1;
                                this.isEmpty = false;
                                this.eventType = 1;
                                return 1;
                            }
                            if (c == '/') {
                                this.elemStack[this.depth++] = this.qname(this.cb);
                                this.seq();
                                this.state = 13;
                                break block0;
                            }
                            if (c == ':') {
                                this.prefixSep = this.cb.pos();
                            } else if (c <= ' ') {
                                this.elemStack[this.depth++] = this.qname(this.cb);
                                this.seq();
                                this.state = 7;
                                break block0;
                            }
                        }
                        this.cb.put(c);
                        c = this.nextChar();
                    }
                }
                case 7: {
                    if (c == '>') {
                        this.state = 1;
                        this.isEmpty = false;
                        this.eventType = 1;
                        return 1;
                    }
                    if (c == '/') {
                        this.state = 13;
                        break;
                    }
                    if (c <= ' ') continue block19;
                    this.cb.reset();
                    this.cb.put(c);
                    this.attrPrefixSep = -1;
                    this.state = 8;
                    break;
                }
                case 8: {
                    while (true) {
                        if (c < '@') {
                            if (c <= ' ') {
                                this.attrQName = this.cb;
                                this.seq();
                                this.state = 9;
                                break block0;
                            }
                            if (c == '=') {
                                this.attrQName = this.cb;
                                this.seq();
                                this.state = 10;
                                break block0;
                            }
                            if (c == ':') {
                                this.attrPrefixSep = this.cb.pos();
                            }
                        }
                        this.cb.put(c);
                        c = this.nextChar();
                    }
                }
                case 9: {
                    if (c == '=') {
                        this.state = 10;
                        break;
                    }
                    if (c <= ' ') continue block19;
                    throw new XmlChannelReaderException(XmlChannelReaderException.Type.EXPECTED_EQUALS, this);
                }
                case 10: {
                    if (c == '\'') {
                        this.state = 11;
                        break;
                    }
                    if (c == '\"') {
                        this.state = 12;
                        break;
                    }
                    if (c <= ' ') continue block19;
                    throw new XmlChannelReaderException(XmlChannelReaderException.Type.EXPECTED_QUOTES, this);
                }
                case 11: {
                    while (true) {
                        if (c == '\'') {
                            this.processAttribute(this.cb);
                            this.seq();
                            this.state = 7;
                            break block0;
                        }
                        this.cb.put(c);
                        c = this.nextChar();
                        if (c != '&') continue;
                        c = this.doReplaceEntity();
                    }
                }
                case 12: {
                    while (true) {
                        if (c == '\"') {
                            this.processAttribute(this.cb);
                            this.seq();
                            this.state = 7;
                            break block0;
                        }
                        this.cb.put(c);
                        c = this.nextChar();
                        if (c != '&') continue;
                        c = this.doReplaceEntity();
                    }
                }
                case 13: {
                    if (c == '>') {
                        this.state = 1;
                        this.isEmpty = true;
                        this.eventType = 1;
                        return 1;
                    }
                    throw new XmlChannelReaderException(XmlChannelReaderException.Type.EXPECTED_GREATER, this);
                }
                case 14: {
                    while (true) {
                        if (c < '@') {
                            if (c == '>') {
                                this.qname(this.cb);
                                this.state = 1;
                                if (!this.qName.doEquals(this.elemStack[this.depth - 1])) {
                                    throw new XmlChannelReaderException(XmlChannelReaderException.Type.UNEXPECTED_TAG, this);
                                }
                                this.eventType = 2;
                                if (this.preserveSpace == this.depth) {
                                    this.preserveSpace = -1;
                                }
                                return 2;
                            }
                            if (c == ':') {
                                this.prefixSep = this.cb.pos();
                            } else if (c <= ' ') {
                                this.qname(this.cb);
                                this.state = 15;
                                break block0;
                            }
                        }
                        this.cb.put(c);
                        c = this.nextChar();
                    }
                }
                case 15: {
                    if (c == '>') {
                        this.state = 1;
                        if (!this.qName.doEquals(this.elemStack[this.depth])) {
                            throw new XmlChannelReaderException(XmlChannelReaderException.Type.UNEXPECTED_TAG, this);
                        }
                        this.eventType = 2;
                        if (this.preserveSpace == this.depth) {
                            this.preserveSpace = -1;
                        }
                        return 2;
                    }
                    if (c <= ' ') continue block19;
                    throw new XmlChannelReaderException(XmlChannelReaderException.Type.EXPECTED_GREATER, this);
                }
                default: {
                    throw new XmlChannelReaderException(XmlChannelReaderException.Type.STATE_UNKOWN, this);
                }
            }
        }
        return this.eventType;
    }

    @Override
    public final void nextStartOrEndElement() {
        if (this.eventType == 8) {
            return;
        }
        do {
            this.eventType = this.next();
            if (this.eventType != 1) continue;
            return;
        } while (this.eventType != 2);
    }

    public final void setBuffer(MappedByteBuffer buf) {
        this.buf = buf;
        this.adr = Buffers.address(buf);
        this.max = this.adr + (long)buf.limit();
        this.cb = this.seqs[0];
        this.seqsIdx = 0;
        buf.mark();
        if (buf.remaining() > 4 && buf.get() == 60 && buf.get() == 63 && buf.get() == 120 && buf.get() == 109 && buf.get() == 108 && buf.get() == 32) {
            buf.reset();
            this.next();
            this.prolog = this.getPIData();
            this.eventType = 7;
        } else {
            buf.reset();
        }
    }

    @Override
    public final int getEventType() {
        return this.eventType;
    }

    @Override
    public final int getDepth() {
        return this.depth;
    }

    @Override
    public final ProcessingInstruction getProlog() {
        return this.prolog;
    }

    protected void reset() {
        this.buf = null;
        this.adr = 0L;
        this.prolog = null;
        this.context = null;
        this.charactersPending = false;
        this.eventType = -1;
        this.state = 1;
        this.isEmpty = false;
        this.attrPrefixSep = 0;
        this.depth = 0;
        if (this.clearcache) {
            this.elemStackCache.clear();
        }
        this.attrQName = null;
        this.cb = null;
        this.seqsIdx = 0;
        this.text = null;
        for (int i = 0; i < 128 && this.elemStack[i] != null; ++i) {
            this.elemStack[i] = null;
            this.seqs[i].clean();
        }
        this.namespaces.reset();
    }

    public void forEach(Externalizable object, AttributeConsumer consumer) {
        this.attributes.forEach(object, consumer);
    }

    private char nextChar() {
        byte c;
        if (this.adr == this.max) {
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.PREMATURE_END_OF_FILE, this);
        }
        if (((c = UNSAFE.getByte(this.adr++)) & 0x80) == 0) {
            return (char)c;
        }
        if ((c & 0xE0) == 192) {
            return (char)((c & 0x1F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F);
        }
        if ((c & 0xF0) == 224) {
            return (char)(((c & 0xF) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F);
        }
        if ((c & 0xF8) == 240) {
            return (char)((((c & 0x7F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F);
        }
        if ((c & 0xFC) == 248) {
            return (char)(((((c & 3) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F);
        }
        if ((c & 0xFE) == 252) {
            return (char)((((((c & 1) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F) << 6 | UNSAFE.getByte(this.adr++) & 0x3F);
        }
        throw new UnsupportedOperationException("byte [" + c + "] -> [" + (c & 0xF0) + "] to char ??? -> [" + this.cb + "]");
    }

    private void processAttribute(CharBuffer attrValue) {
        if (this.attrPrefixSep < 0) {
            if (XmlChannelReader.isXMLNS(this.attrQName)) {
                this.namespaces.setPrefixDefault(attrValue);
            } else {
                this.attributes.addAttribute(this.attrQName, 0, attrValue);
            }
            return;
        }
        CharBuffer cb = this.attrQName;
        if (cb.length() > 6 && cb.charAt(0) == 'x' && cb.charAt(1) == 'm' && cb.charAt(2) == 'l' && cb.charAt(3) == 'n' && cb.charAt(4) == 's') {
            this.namespaces.setPrefix(this, CharArrays.immutable(cb, 6, cb.length() - 6), CharArrays.immutable(attrValue));
            this.nsStack[this.depth - 1] = this.nsStack[this.depth - 1] == null ? NamespacesImpl.POP_ACTION : this.nsStack[this.depth - 1].andThen(NamespacesImpl.POP_ACTION);
        } else {
            this.attributes.addAttribute(this.attrQName, this.attrPrefixSep, attrValue);
        }
    }

    private static boolean isXMLNS(CharArray chars) {
        return chars.length() == 5 && chars.charAt(0) == 'x' && chars.charAt(1) == 'm' && chars.charAt(2) == 'l' && chars.charAt(3) == 'n' && chars.charAt(4) == 's';
    }

    private QNameImpl qname(CharBuffer buf) {
        int hashCode = this.cb.hashCode();
        QNameImpl cacheQName = this.elemStackCache.get(hashCode);
        if (cacheQName == null) {
            cacheQName = new QNameImpl(this.cb.value(), this.cb.pos(), this.prefixSep);
            this.elemStackCache.put(hashCode, cacheQName);
        }
        this.qName = cacheQName;
        buf.reset();
        return cacheQName;
    }

    private void seq() {
        this.seqsIdx = (this.seqsIdx + 1) % 128;
        this.cb = this.seqs[this.seqsIdx];
        this.cb.reset();
    }

    private char doReplaceEntity() {
        byte b;
        if (this.state == 3 || this.state == 4 || this.state == 5) {
            return '&';
        }
        if (this.adr == this.max) {
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.PREMATURE_END_OF_FILE, this);
        }
        if ((b = UNSAFE.getByte(this.adr++)) == 97) {
            if ((b = UNSAFE.getByte(this.adr++)) == 109) {
                if (112 == UNSAFE.getByte(this.adr++) && 59 == UNSAFE.getByte(this.adr++)) {
                    return '&';
                }
                throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
            }
            if (b == 112) {
                if (111 == UNSAFE.getByte(this.adr++) && 115 == UNSAFE.getByte(this.adr++) && 59 == UNSAFE.getByte(this.adr++)) {
                    return '\'';
                }
                throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
            }
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
        }
        if (b == 103) {
            if (116 == UNSAFE.getByte(this.adr++) && 59 == UNSAFE.getByte(this.adr++)) {
                return '>';
            }
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
        }
        if (b == 108) {
            if (116 == UNSAFE.getByte(this.adr++) && 59 == UNSAFE.getByte(this.adr++)) {
                return '<';
            }
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
        }
        if (b == 35) {
            char c = this.nextChar();
            if (c == 'x') {
                throw new UnsupportedOperationException();
            }
            int charValue = 0;
            while (c != ';') {
                charValue *= 10;
                charValue += c - 48;
                c = this.nextChar();
            }
            return (char)charValue;
        }
        if (b == 113) {
            if (117 == UNSAFE.getByte(this.adr++) && 111 == UNSAFE.getByte(this.adr++) && 116 == UNSAFE.getByte(this.adr++) && 59 == UNSAFE.getByte(this.adr++)) {
                return '\"';
            }
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
        }
        throw new XmlChannelReaderException(XmlChannelReaderException.Type.REPLACE_ENTITY, this);
    }

    private boolean isEndOfBuffer() {
        if (this.adr >= this.max) {
            if (this.eventType == 8) {
                throw new XmlChannelReaderException(XmlChannelReaderException.Type.PREMATURE_END_OF_FILE, this);
            }
            if (this.cb.length() > 0) {
                if (this.charactersPending) {
                    this.text = this.cb;
                    this.seq();
                } else {
                    this.seq();
                    this.text = this.cb;
                }
                this.eventType = 4;
            } else {
                this.eventType = 8;
            }
            return true;
        }
        return false;
    }

    private char handleEndOfLine(char c) {
        if (c == '\r') {
            c = (char)10;
        }
        if (c == '\u0000') {
            throw new XmlChannelReaderException(XmlChannelReaderException.Type.ILLEGAL_CHAR_0000, this);
        }
        return c;
    }

    int getState() {
        return this.state;
    }

    int getSeqsIdx() {
        return this.seqsIdx;
    }

    CharBuffer getCb() {
        return this.cb;
    }

    int getPosition() {
        return this.buf.limit() - (int)(this.max - this.adr);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(false);
        XmlChannelReaderException.dump(builder, this);
        return builder.toString();
    }
}

