/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.io.impl.XmlChannelReader;
import io.legaldocml.util.ToStringBuilder;

public final class XmlChannelReaderException
extends RuntimeException {
    private static final String[] NAMES_OF_EVENTS = new String[]{"UNDEFINED", "START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTIONS", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};
    private static final String[] NAMES_OF_STATES = new String[]{"INVALID", "STATE_CHARACTERS", "STATE_MARKUP", "STATE_COMMENT", "STATE_PI", "STATE_CDATA", "STATE_OPEN_TAG_READ_ELEM_NAME", "STATE_OPEN_TAG_ELEM_NAME_READ", "STATE_OPEN_TAG_READ_ATTR_NAME", "STATE_OPEN_TAG_ATTR_NAME_READ", "STATE_OPEN_TAG_EQUAL_READ", "STATE_OPEN_TAG_READ_ATTR_VALUE_SIMPLE_QUOTE", "STATE_OPEN_TAG_READ_ATTR_VALUE_DOUBLE_QUOTE", "STATE_OPEN_TAG_EMPTY_TAG", "STATE_CLOSE_TAG_READ_ELEM_NAME", "STATE_CLOSE_TAG_ELEM_NAME_READ", "STATE_DTD", "STATE_DTD_INTERNAL"};
    private final Type type;

    XmlChannelReaderException(Type type, XmlChannelReader reader) {
        this(type, reader, null);
    }

    XmlChannelReaderException(Type type, XmlChannelReader reader, String message) {
        super(XmlChannelReaderException.buildMsg(type, reader, message));
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    private static String buildMsg(Type type, XmlChannelReader reader, String message) {
        ToStringBuilder builder = new ToStringBuilder(true);
        builder.append("type", (Object)type);
        if (message != null) {
            builder.append("message", message);
        }
        XmlChannelReaderException.dump(builder, reader);
        return builder.toString();
    }

    static void dump(ToStringBuilder builder, XmlChannelReader reader) {
        builder.append("eventType", reader.getEventType());
        builder.append("eventTypeName", NAMES_OF_EVENTS[reader.getEventType()]);
        builder.append("state", reader.getState());
        builder.append("stateName", NAMES_OF_STATES[reader.getState()]);
        builder.append("depth", reader.getDepth());
        builder.append("seqsIdx", reader.getSeqsIdx());
        builder.append("buffer", reader.getCb());
        builder.append("position", reader.getPosition());
    }

    public static enum Type {
        REPLACE_ENTITY,
        PREMATURE_END_OF_FILE,
        ILLEGAL_CHAR_0000,
        EXPECTED_QUOTES,
        EXPECTED_EQUALS,
        EXPECTED_GREATER,
        UNEXPECTED_TAG,
        STATE_UNKOWN,
        INVALID_EVENT_TYPE_TEXT,
        INVALID_EVENT_TYPE_PI,
        INVALID_EVENT_TYPE_QNAME,
        NAMESPACE_ERROR;

    }
}

