/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.LegalDocMlException;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.unsafe.UnsafeHelper;
import io.legaldocml.unsafe.UnsafeString;
import io.legaldocml.util.Maths;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

public abstract class XmlChannelWriter
implements XmlWriter {
    private static final byte START_TAG = 60;
    private static final byte END_TAG = 62;
    private static final byte SPACE = 32;
    private static final byte EQUALS = 61;
    private static final byte DOUBLE_QUOTE = 34;
    private static final byte CHAR_T = 84;
    private static final byte CHAR_DASH = 45;
    private static final byte CHAR_COLON = 58;
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();
    private static final MappedByteBuffer BUFFER_ENTITY_AMP = Buffers.direct(new byte[]{38, 97, 109, 112, 59});
    private static final long ADDRESS_ENTITY_AMP = Buffers.address(BUFFER_ENTITY_AMP);
    private static final MappedByteBuffer BUFFER_ENTITY_LT = Buffers.direct(new byte[]{38, 108, 116, 59});
    private static final long ADDRESS_ENTITY_LT = Buffers.address(BUFFER_ENTITY_LT);
    private static final MappedByteBuffer BUFFER_ENTITY_GT = Buffers.direct(new byte[]{38, 103, 116, 59});
    private static final long ADDRESS_ENTITY_GT = Buffers.address(BUFFER_ENTITY_GT);
    private static final MappedByteBuffer BUFFER_ENTITY_QUOT = Buffers.direct(new byte[]{38, 113, 117, 111, 116, 59});
    private static final long ADDRESS_ENTITY_QUOT = Buffers.address(BUFFER_ENTITY_QUOT);
    private static final MappedByteBuffer BUFFER_END_SINGLE_TAG = Buffers.direct(new byte[]{47, 62});
    private static final long ADDRESS_END_SINGLE_TAG = Buffers.address(BUFFER_END_SINGLE_TAG);
    private static final MappedByteBuffer BUFFER_ARRAY_END = Buffers.direct(new byte[]{60, 47});
    private static final long ADDRESS_ARRAY_END = Buffers.address(BUFFER_ARRAY_END);
    private static final MappedByteBuffer BUF_HEADER = Buffers.direct(new byte[]{60, 63, 120, 109, 108, 32, 118, 101, 114, 115, 105, 111, 110, 61, 34, 49, 46, 48, 34, 32, 101, 110, 99, 111, 100, 105, 110, 103, 61, 34, 85, 84, 70, 45, 56, 34, 63, 62});
    private static final long BUF_HEADER_ADDRESS = Buffers.address(BUF_HEADER);
    private static final byte[] PI_START = new byte[]{60, 63};
    private static final byte[] PI_END = new byte[]{63, 62};
    private final boolean[] hasElements = new boolean[128];
    private int elem = 0;
    private final long[] namespaces = new long[8];
    private final long[] namespacesSize = new long[8];
    private int namespacesPtr = -1;
    private WritableByteChannel channel;
    private final MappedByteBuffer buffer = (MappedByteBuffer)ByteBuffer.allocateDirect(32768);
    private final Long address = Buffers.address(this.buffer);
    private boolean permissive = false;
    private List<LegalDocMlException> exceptions;

    public void setChannel(WritableByteChannel channel) {
        this.channel = channel;
    }

    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    @Override
    public void writeStartDocument(long address, int len) {
        this.buffer.clear();
        UNSAFE.copyMemory(BUF_HEADER_ADDRESS, this.address, 38L);
        int pos = 38;
        UNSAFE.putByte(this.address + (long)pos++, (byte)60);
        UNSAFE.copyMemory(address, this.address + (long)pos, len);
        this.buffer.position(pos += len);
        this.hasElements[++this.elem] = true;
    }

    @Override
    public void writeEndDocument(long address, int len) throws IOException {
        int pos = this.buffer.position();
        UNSAFE.copyMemory(ADDRESS_ARRAY_END, this.address + (long)pos, 2L);
        UNSAFE.copyMemory(address, this.address + (long)(pos += 2), len);
        UNSAFE.putByte(this.address + (long)pos++ + (long)len, (byte)62);
        this.buffer.position(pos + len);
    }

    @Override
    public void writeAttribute(long name, int nameLen, char[] value) throws IOException {
        this.checkSize(nameLen + value.length + 4);
        int pos = this.buffer.position();
        UNSAFE.putByte(this.address + (long)pos++, (byte)32);
        UNSAFE.copyMemory(name, this.address + (long)pos, nameLen);
        pos += nameLen;
        UNSAFE.putByte(this.address + (long)pos++, (byte)61);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        pos = this.raw(value, 0, value.length, pos);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        this.buffer.position(pos);
    }

    @Override
    public void writeAttribute(long name, int nameLen, byte[] value) throws IOException {
        this.checkSize(nameLen + value.length + 16);
        long addr = this.address + (long)this.buffer.position();
        UNSAFE.putByte(addr++, (byte)32);
        UNSAFE.copyMemory(name, addr, nameLen);
        addr += (long)nameLen;
        UNSAFE.putByte(addr++, (byte)61);
        UNSAFE.putByte(addr++, (byte)34);
        UNSAFE.copyMemory(value, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET, null, addr, value.length);
        addr += (long)value.length;
        UNSAFE.putByte(addr++, (byte)34);
        this.buffer.position((int)(addr - this.address));
    }

    @Override
    public void writeAttribute(long name, int nameLen, LocalDate date) throws IOException {
        this.checkSize(nameLen + 20);
        int pos = this.buffer.position();
        UNSAFE.putByte(this.address + (long)pos++, (byte)32);
        UNSAFE.copyMemory(name, this.address + (long)pos, nameLen);
        pos += nameLen;
        UNSAFE.putByte(this.address + (long)pos++, (byte)61);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        pos = this.raw(date, pos);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        this.buffer.position(pos);
    }

    @Override
    public void writeAttribute(long name, int nameLen, OffsetDateTime offsetDateTime) throws IOException {
        this.checkSize(nameLen + 30);
        int pos = this.buffer.position();
        UNSAFE.putByte(this.address + (long)pos++, (byte)32);
        UNSAFE.copyMemory(name, this.address + (long)pos, nameLen);
        pos += nameLen;
        UNSAFE.putByte(this.address + (long)pos++, (byte)61);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        pos = this.raw(offsetDateTime, pos);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        this.buffer.position(pos);
    }

    public void write(char[] text, int off, int len) throws IOException {
        this.checkSize(text.length << 2);
        int pos = this.buffer.position();
        if (this.hasElements[this.elem]) {
            this.hasElements[this.elem] = false;
            UNSAFE.putByte(this.address + (long)pos++, (byte)62);
        }
        this.buffer.position(this.raw(text, off, len, pos));
    }

    @Override
    public void write(char[] text) throws IOException {
        this.write(text, 0, text.length);
    }

    private int raw(LocalDate date, int pos) {
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + Maths.unsignedDiv1000(year)));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + Maths.unsignedDiv100(year) % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + Maths.unsignedDiv10(year) % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + year % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)45);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + Maths.unsignedDiv10(month)));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + month % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)45);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + Maths.unsignedDiv10(day)));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + day % 10));
        return pos;
    }

    private int raw(OffsetDateTime dateTime, int pos) {
        pos = this.raw(dateTime.toLocalDate(), pos);
        UNSAFE.putByte(this.address + (long)pos++, (byte)84);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + dateTime.getHour() / 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + dateTime.getHour() % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)58);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + dateTime.getMinute() / 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + dateTime.getMinute() % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)58);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + dateTime.getSecond() / 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + dateTime.getSecond() % 10));
        if (dateTime.getOffset().getTotalSeconds() != 0) {
            char[] offset = UnsafeString.getChars(dateTime.getOffset().toString());
            return this.raw(offset, 0, offset.length, pos);
        }
        return pos;
    }

    private int raw(char[] text, int off, int len, int pos) {
        long addr = this.address + (long)pos;
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char c = text[i];
            if (c < '\u0080') {
                switch (c) {
                    case '&': {
                        UNSAFE.copyMemory(ADDRESS_ENTITY_AMP, addr, 5L);
                        addr += 5L;
                        break;
                    }
                    case '<': {
                        UNSAFE.copyMemory(ADDRESS_ENTITY_LT, addr, 4L);
                        addr += 4L;
                        break;
                    }
                    case '>': {
                        UNSAFE.copyMemory(ADDRESS_ENTITY_GT, addr, 4L);
                        addr += 4L;
                        break;
                    }
                    case '\"': {
                        UNSAFE.copyMemory(ADDRESS_ENTITY_QUOT, addr, 6L);
                        addr += 6L;
                        break;
                    }
                    default: {
                        UNSAFE.putByte(addr++, (byte)c);
                        break;
                    }
                }
                continue;
            }
            if (c < '\u0800') {
                UNSAFE.putByte(addr++, (byte)(0xC0 | c >> 6));
                UNSAFE.putByte(addr++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (c <= '\uffff') {
                UNSAFE.putByte(addr++, (byte)(0xE0 | c >> 12));
                UNSAFE.putByte(addr++, (byte)(0x80 | c >> 6 & 0x3F));
                UNSAFE.putByte(addr++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (c > '\u10ffff') {
                throw new IllegalStateException();
            }
            UNSAFE.putByte(addr++, (byte)(0xF0 | c >> 18));
            UNSAFE.putByte(addr++, (byte)(0x80 | c >> 12 & 0x3F));
            UNSAFE.putByte(addr++, (byte)(0x80 | c >> 6 & 0x3F));
            UNSAFE.putByte(addr++, (byte)(0x80 | c & 0x3F));
        }
        return (int)(addr - this.address);
    }

    private void checkSize(int limit) throws IOException {
        if (this.buffer.remaining() < limit) {
            this.buffer.flip();
            this.channel.write(this.buffer);
            this.buffer.clear();
        }
    }

    @Override
    public void writeStart(long address, int len) throws IOException {
        this.checkSize(len << 2);
        long adr = this.address + (long)this.buffer.position();
        if (this.hasElements[this.elem]) {
            this.hasElements[this.elem] = false;
            UNSAFE.putByte(adr++, (byte)62);
        }
        UNSAFE.putByte(adr++, (byte)60);
        if (this.namespacesPtr >= 0) {
            long nsAdr = this.namespaces[this.namespacesPtr];
            long nsLen = this.namespacesSize[this.namespacesPtr];
            UNSAFE.copyMemory(nsAdr, adr, nsLen);
            adr += nsLen;
            UNSAFE.putByte(adr++, (byte)58);
        }
        UNSAFE.copyMemory(address, adr, len);
        this.buffer.position((int)(adr - this.address) + len);
        this.hasElements[++this.elem] = true;
    }

    @Override
    public void writeEnd(long address, int len) throws IOException {
        this.checkSize(len << 2);
        if (!this.hasElements[this.elem--]) {
            long adr = this.address + (long)this.buffer.position();
            UNSAFE.copyMemory(ADDRESS_ARRAY_END, adr, 2L);
            adr += 2L;
            if (this.namespacesPtr >= 0) {
                long nsAdr = this.namespaces[this.namespacesPtr];
                long nsLen = this.namespacesSize[this.namespacesPtr];
                UNSAFE.copyMemory(nsAdr, adr, nsLen);
                adr += nsLen;
                UNSAFE.putByte(adr++, (byte)58);
            }
            UNSAFE.copyMemory(address, adr, len);
            UNSAFE.putByte(adr + (long)len, (byte)62);
            this.buffer.position((int)(adr - this.address) + len + 1);
        } else {
            int pos = this.buffer.position();
            UNSAFE.copyMemory(ADDRESS_END_SINGLE_TAG, this.address + (long)pos, 2L);
            this.buffer.position(pos + 2);
        }
    }

    public void write(LocalDate date) throws IOException {
        this.checkSize(16);
        int pos = this.buffer.position();
        if (this.hasElements[this.elem]) {
            this.hasElements[this.elem] = false;
            UNSAFE.putByte(this.address + (long)pos++, (byte)62);
        }
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + year / 1000));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + year / 100 % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + year / 10 % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + year % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)45);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + month / 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + month % 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)45);
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + day / 10));
        UNSAFE.putByte(this.address + (long)pos++, (byte)(48 + day % 10));
        this.buffer.position(pos);
    }

    @Override
    public void writeNamespace(long key, int keyLen, long value, int valueLen) throws IOException {
        this.checkSize(keyLen + valueLen + 4);
        int pos = this.buffer.position();
        UNSAFE.putByte(this.address + (long)pos++, (byte)32);
        UNSAFE.copyMemory(key, this.address + (long)pos, keyLen);
        pos += keyLen;
        UNSAFE.putByte(this.address + (long)pos++, (byte)61);
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        UNSAFE.copyMemory(value, this.address + (long)pos, valueLen);
        pos += valueLen;
        UNSAFE.putByte(this.address + (long)pos++, (byte)34);
        this.buffer.position(pos);
    }

    public static byte[] getPiStart() {
        return (byte[])PI_START.clone();
    }

    public static byte[] getPiEnd() {
        return (byte[])PI_END.clone();
    }

    public void pushNS(long addr, long size) {
        ++this.namespacesPtr;
        this.namespaces[this.namespacesPtr] = addr;
        this.namespacesSize[this.namespacesPtr] = size;
    }

    public void popNS() {
        --this.namespacesPtr;
    }

    protected void reset() {
        this.channel = null;
        this.elem = 0;
        this.namespacesPtr = -1;
        this.permissive = false;
        this.exceptions = null;
        this.buffer.clear();
    }

    @Override
    public void setPermissive(boolean value) {
        this.permissive = value;
    }

    @Override
    public boolean isPermissive() {
        return this.permissive;
    }

    @Override
    public void addExpcetion(LegalDocMlException exception) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<LegalDocMlException>(8);
        }
        this.exceptions.add(exception);
    }

    public List<LegalDocMlException> getExceptions() {
        return this.exceptions;
    }
}

