/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.io.impl;

import io.legaldocml.akn.AkomaNtoso;
import io.legaldocml.akn.DocumentType;
import io.legaldocml.akn.util.XmlReaderHelper;
import io.legaldocml.io.XmlReaderFactory;
import io.legaldocml.io.impl.XmlChannelReader;
import io.legaldocml.pool.Pool;
import io.legaldocml.pool.PoolHolder;
import io.legaldocml.pool.PoolableObject;
import io.legaldocml.pool.Pools;
import java.nio.MappedByteBuffer;

final class XmlReaderFactoryImpl
implements XmlReaderFactory {
    private static final PoolableObject<XmlChannelReader> POOLABLE_OBJECT = new PoolableObject<XmlChannelReader>(){

        @Override
        public XmlChannelReader newInstance() {
            return new XmlChannelReader(false);
        }

        @Override
        public void passivate(XmlChannelReader xmlReader) {
            xmlReader.reset();
        }
    };
    private final Pool<PoolHolder<XmlChannelReader>> pool;

    XmlReaderFactoryImpl(int size) {
        this.pool = Pools.createPool(size, POOLABLE_OBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DocumentType> AkomaNtoso<T> read(MappedByteBuffer buffer) {
        PoolHolder<XmlChannelReader> holder = null;
        try {
            holder = this.pool.checkOut();
            XmlChannelReader reader = (XmlChannelReader)holder.get();
            reader.setBuffer(buffer);
            reader.nextStartOrEndElement();
            AkomaNtoso akomaNtoso = XmlReaderHelper.createAkomaNtoso(reader);
            akomaNtoso.read(reader);
            AkomaNtoso akomaNtoso2 = akomaNtoso;
            return akomaNtoso2;
        }
        finally {
            if (holder != null) {
                this.pool.checkIn(holder);
            }
        }
    }
}

