/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.model;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.iso.Iso3166;
import io.legaldocml.iso.Iso639;
import io.legaldocml.model.Country;
import io.legaldocml.model.Language;
import io.legaldocml.model.ModelProvider;

public final class DefaultModelProvider
implements ModelProvider {
    public static final DefaultModelProvider INSTANCE = new DefaultModelProvider();
    private static final ImmutableMap<String, Iso639> ALL_LANGUAGES;
    private static final ImmutableMap<String, Iso3166> COUNTRY_ALL;

    private DefaultModelProvider() {
    }

    @Override
    public Country country(String code) {
        return (Country)COUNTRY_ALL.get((Object)code);
    }

    @Override
    public Language language(String code) {
        return (Language)ALL_LANGUAGES.get((Object)code);
    }

    static {
        Enum[] values = Iso639.values();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Iso639 iso639 : values) {
            if (iso639.getCode() != null) {
                builder.put((Object)iso639.getCode(), (Object)iso639);
            }
            if (!iso639.getBibliographic().equals(iso639.getTerminology())) {
                builder.put((Object)iso639.getBibliographic(), (Object)iso639);
            }
            builder.put((Object)iso639.getTerminology(), (Object)iso639);
        }
        ALL_LANGUAGES = builder.build();
        values = Iso3166.values();
        ImmutableMap.Builder builderAll = ImmutableMap.builder();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        ImmutableMap.Builder builder3 = ImmutableMap.builder();
        for (Enum val : values) {
            builderAll.put((Object)((Iso3166)val).getAlpha2(), (Object)val);
            builder2.put((Object)((Iso3166)val).getAlpha2(), (Object)val);
            builderAll.put((Object)((Iso3166)val).getAlpha3(), (Object)val);
            builder3.put((Object)((Iso3166)val).getAlpha3(), (Object)val);
        }
        COUNTRY_ALL = builderAll.build();
    }
}

