/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.module;

import com.google.common.collect.ImmutableMap;
import io.legaldocml.module.Module;
import io.legaldocml.util.CharArray;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Modules {
    private static final Logger LOGGER = LoggerFactory.getLogger(Modules.class);
    private static final ImmutableMap<CharArray, Module> ALL_MODULES;

    private Modules() {
    }

    public static Module get(CharArray key) {
        return (Module)ALL_MODULES.get((Object)key);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ServiceLoader.load(Module.class).forEach(c -> {
            LOGGER.info("load Module [{}]", c);
            builder.put((Object)c.namespace(), c);
        });
        ALL_MODULES = builder.build();
    }
}

