/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.module.xml;

import io.legaldocml.akn.AkomaNtosoContext;
import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.model.Language;
import io.legaldocml.model.ModelProvider;
import io.legaldocml.module.xml.attribute.XmlLang;
import io.legaldocml.unsafe.UnsafeString;
import io.legaldocml.util.CharArray;
import java.io.IOException;

final class XmlLangImpl
implements XmlLang {
    public static final String ATTRIBUTE = "xml:lang";
    private static final long ADDRESS = Buffers.address("xml:lang");
    private Language language;

    XmlLangImpl() {
    }

    @Override
    public Language getXmlLang() {
        return this.language;
    }

    @Override
    public void setXmlLang(Language xmlLang) {
        this.language = xmlLang;
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        if (this.language != null) {
            writer.writeAttribute(ADDRESS, 8, UnsafeString.getChars(this.language.getCode()));
        }
    }

    @Override
    public void read(XmlReader reader, CharArray value) {
        ModelProvider provider = ((AkomaNtosoContext)reader.getContext()).getModelProvider();
        this.language = provider.language(value.toString());
    }
}

