/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.module.xml;

import io.legaldocml.io.XmlReader;
import io.legaldocml.io.XmlWriter;
import io.legaldocml.io.impl.Buffers;
import io.legaldocml.module.xml.attribute.XmlSpace;
import io.legaldocml.module.xml.type.Space;
import io.legaldocml.unsafe.UnsafeString;
import io.legaldocml.util.CharArray;
import java.io.IOException;

final class XmlSpaceImpl
implements XmlSpace {
    public static final String ATTRIBUTE = "xml:space";
    private static final long ADDRESS = Buffers.address("xml:space");
    private Space value;

    XmlSpaceImpl() {
    }

    @Override
    public void write(XmlWriter writer) throws IOException {
        if (this.value != null) {
            writer.writeAttribute(ADDRESS, 9, UnsafeString.getChars(this.value.toString()));
        }
    }

    @Override
    public void read(XmlReader reader, CharArray value) {
        this.value = Space.valueOf(value.toString().toUpperCase());
        if (Space.PRESERVE == this.value) {
            reader.preserveSpace();
        }
    }

    @Override
    public Space getSpace() {
        return this.value;
    }

    @Override
    public void setSpace(Space space) {
        this.value = space;
    }
}

