/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.pool;

import io.legaldocml.pool.Pool;
import io.legaldocml.pool.PoolHolder;
import io.legaldocml.pool.PoolableObject;
import io.legaldocml.pool.UnsafeHolder;
import io.legaldocml.unsafe.UnsafeHelper;
import java.io.Closeable;
import sun.misc.Unsafe;

final class UnsafePool<T>
implements Pool<PoolHolder<T>>,
Closeable {
    private final long adr;
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();
    private final UnsafeHolder[] holders;
    private final int size;
    private final PoolableObject<T> poolableObject;
    private int index;
    private boolean isClosed;

    UnsafePool(int size, PoolableObject<T> poolableObject) {
        this.poolableObject = poolableObject;
        this.adr = UNSAFE.allocateMemory((long)size * 8L);
        this.holders = new UnsafeHolder[size];
        for (int i = 0; i < size; ++i) {
            this.holders[i] = new UnsafeHolder<T>(poolableObject.newInstance());
        }
        this.size = size;
        this.isClosed = false;
    }

    @Override
    public UnsafeHolder<T> checkOut() {
        int i;
        int size = this.size;
        int index = this.index;
        UnsafeHolder[] holders = this.holders;
        for (i = index; i < size; ++i) {
            if (!UNSAFE.compareAndSwapInt(holders[i], UnsafeHolder.FIELD_OFFSET, 0, 1)) continue;
            this.index = i;
            return holders[i];
        }
        for (i = 0; i < index; ++i) {
            if (!UNSAFE.compareAndSwapInt(holders[i], UnsafeHolder.FIELD_OFFSET, 0, 1)) continue;
            this.index = i;
            return holders[i];
        }
        return this.checkOut(0, size, holders);
    }

    private UnsafeHolder<T> checkOut(int count, int size, UnsafeHolder[] holders) {
        if (count == 100) {
            return new UnsafeHolder<T>(this.poolableObject.newInstance(), 2);
        }
        Thread.yield();
        for (int i = 0; i < size; ++i) {
            if (!UNSAFE.compareAndSwapInt(holders[i], UnsafeHolder.FIELD_OFFSET, 0, 1)) continue;
            return holders[i];
        }
        return this.checkOut(count + 1, size, holders);
    }

    @Override
    public void checkIn(PoolHolder<T> holder) {
        if (2 == holder.getState()) {
            return;
        }
        holder.setState(0);
        this.poolableObject.passivate(holder.get());
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            UNSAFE.freeMemory(this.adr);
            this.isClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

