/*
 * Decompiled with CFR 0.152.
 */
package io.legaldocml.unsafe;

import io.legaldocml.unsafe.UnsafeHelper;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;

public final class UnsafeString {
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();
    private static final long VALUE_OFFSET = UnsafeHelper.getFieldOffset(String.class, "value");
    private static final char[] EMPTY = new char[0];
    private static final JavaLangAccess JAVA_LANG_ACCESS = SharedSecrets.getJavaLangAccess();

    private UnsafeString() {
    }

    public static String buildUnsafe(char[] chars) {
        if (chars == null || chars.length == 0) {
            return "";
        }
        String mutable = new String();
        UNSAFE.putObject(mutable, VALUE_OFFSET, chars);
        return mutable;
    }

    public static char[] getChars(String s) {
        if (s == null) {
            return EMPTY;
        }
        return (char[])UNSAFE.getObject(s, VALUE_OFFSET);
    }

    public static String valueOf(char[] chars) {
        if (chars == null || chars.length == 0) {
            return "";
        }
        return JAVA_LANG_ACCESS.newStringUnsafe(chars);
    }
}

